/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.balancer.Balancer;
import com.predic8.membrane.core.interceptor.balancer.Cluster;
import com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.interceptor.balancer.Session;
import com.predic8.membrane.core.rules.Rule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BalancerUtil {
    public static List<Cluster> collectClusters(Router router) {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        for (Rule r : router.getRuleManager().getRules()) {
            List<Interceptor> interceptors = r.getInterceptors();
            if (interceptors == null) continue;
            for (Interceptor i : interceptors) {
                if (!(i instanceof LoadBalancingInterceptor)) continue;
                result.addAll(((LoadBalancingInterceptor)i).getClusterManager().getClusters());
            }
        }
        return result;
    }

    public static List<LoadBalancingInterceptor> collectBalancers(Router router) {
        ArrayList<LoadBalancingInterceptor> result = new ArrayList<LoadBalancingInterceptor>();
        for (Rule r : router.getRuleManager().getRules()) {
            List<Interceptor> interceptors = r.getInterceptors();
            if (interceptors == null) continue;
            for (Interceptor i : interceptors) {
                if (!(i instanceof LoadBalancingInterceptor)) continue;
                result.add((LoadBalancingInterceptor)i);
            }
        }
        return result;
    }

    public static Balancer lookupBalancer(Router router, String name) {
        for (Rule r : router.getRuleManager().getRules()) {
            List<Interceptor> interceptors = r.getInterceptors();
            if (interceptors == null) continue;
            for (Interceptor i : interceptors) {
                if (!(i instanceof LoadBalancingInterceptor) || !((LoadBalancingInterceptor)i).getName().equals(name)) continue;
                return ((LoadBalancingInterceptor)i).getClusterManager();
            }
        }
        throw new RuntimeException("balancer with name \"" + name + "\" not found.");
    }

    public static LoadBalancingInterceptor lookupBalancerInterceptor(Router router, String name) {
        for (Rule r : router.getRuleManager().getRules()) {
            List<Interceptor> interceptors = r.getInterceptors();
            if (interceptors == null) continue;
            for (Interceptor i : interceptors) {
                if (!(i instanceof LoadBalancingInterceptor) || !((LoadBalancingInterceptor)i).getName().equals(name)) continue;
                return (LoadBalancingInterceptor)i;
            }
        }
        throw new RuntimeException("balancer with name \"" + name + "\" not found.");
    }

    public static boolean hasLoadBalancing(Router router) {
        for (Rule r : router.getRuleManager().getRules()) {
            List<Interceptor> interceptors = r.getInterceptors();
            if (interceptors == null) continue;
            for (Interceptor i : interceptors) {
                if (!(i instanceof LoadBalancingInterceptor)) continue;
                return true;
            }
        }
        return false;
    }

    public static void up(Router router, String balancerName, String cName, String host, int port) {
        BalancerUtil.lookupBalancer(router, balancerName).up(cName, host, port);
    }

    public static void down(Router router, String balancerName, String cName, String host, int port) {
        BalancerUtil.lookupBalancer(router, balancerName).down(cName, host, port);
    }

    public static void takeout(Router router, String balancerName, String cName, String host, int port) {
        BalancerUtil.lookupBalancer(router, balancerName).takeout(cName, host, port);
    }

    public static List<Node> getAllNodesByCluster(Router router, String balancerName, String cName) {
        return BalancerUtil.lookupBalancer(router, balancerName).getAllNodesByCluster(cName);
    }

    public static List<Node> getAvailableNodesByCluster(Router router, String balancerName, String cName) {
        return BalancerUtil.lookupBalancer(router, balancerName).getAvailableNodesByCluster(cName);
    }

    public static void addSession2Cluster(Router router, String balancerName, String sessionId, String cName, Node n) {
        BalancerUtil.lookupBalancer(router, balancerName).addSession2Cluster(sessionId, cName, n);
    }

    public static void removeNode(Router router, String balancerName, String cluster, String host, int port) {
        BalancerUtil.lookupBalancer(router, balancerName).removeNode(cluster, host, port);
    }

    public static Node getNode(Router router, String balancerName, String cluster, String host, int port) {
        return BalancerUtil.lookupBalancer(router, balancerName).getNode(cluster, host, port);
    }

    public static Map<String, Session> getSessions(Router router, String balancerName, String cluster) {
        return BalancerUtil.lookupBalancer(router, balancerName).getSessions(cluster);
    }

    public static List<Session> getSessionsByNode(Router router, String balancerName, String cName, Node node) {
        return BalancerUtil.lookupBalancer(router, balancerName).getSessionsByNode(cName, node);
    }

    public static String getSingleClusterNameOrDefault(Balancer balancer) {
        if (balancer.getClusters().size() == 1) {
            return balancer.getClusters().get(0).getName();
        }
        return "Default";
    }
}

