/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.interceptor.balancer.DispatchingStrategy;
import com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor;
import com.predic8.membrane.core.interceptor.balancer.Node;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@MCElement(name="byThreadStrategy")
public class ByThreadStrategy
extends AbstractXmlElement
implements DispatchingStrategy {
    private int maxNumberOfThreadsPerEndpoint = 5;
    private Map<String, Integer> endpointCount = new Hashtable<String, Integer>();
    private int retryTimeOnBusy = 1000;

    @Override
    public void done(AbstractExchange exc) {
        String endPoint = exc.getOriginalRequestUri();
        if (this.endpointCount.containsKey(endPoint)) {
            Integer counter;
            Integer n = counter = this.endpointCount.get(endPoint);
            counter = counter - 1;
            if (counter == 0) {
                this.endpointCount.remove(endPoint);
            } else {
                this.endpointCount.put(endPoint, counter);
            }
        }
    }

    @Override
    public Node dispatch(LoadBalancingInterceptor interceptor, AbstractExchange exc) {
        for (int j = 0; j < 5; ++j) {
            for (Node ep : interceptor.getEndpoints()) {
                String hostColonPort = this.getHostColonPort(ep);
                if (!this.endpointCount.containsKey(hostColonPort)) {
                    this.endpointCount.put(hostColonPort, 1);
                    return ep;
                }
                Integer counter = this.endpointCount.get(hostColonPort);
                if (counter >= this.maxNumberOfThreadsPerEndpoint) continue;
                Integer n = counter;
                counter = counter + 1;
                this.endpointCount.put(hostColonPort, counter);
                return ep;
            }
            try {
                Thread.sleep(this.retryTimeOnBusy);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new RuntimeException("All available servers are busy.");
    }

    @MCAttribute
    public void setMaxNumberOfThreadsPerEndpoint(int maxNumberOfThreadsPerEndpoint) {
        this.maxNumberOfThreadsPerEndpoint = maxNumberOfThreadsPerEndpoint;
    }

    @MCAttribute
    public void setRetryTimeOnBusy(int retryTimeOnBusy) {
        this.retryTimeOnBusy = retryTimeOnBusy;
    }

    public int getMaxNumberOfThreadsPerEndpoint() {
        return this.maxNumberOfThreadsPerEndpoint;
    }

    public int getRetryTimeOnBusy() {
        return this.retryTimeOnBusy;
    }

    private String getHostColonPort(Node ep) {
        return ep.getHost() + ":" + ep.getPort();
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("byThreadStrategy");
        out.writeAttribute("retryTimeOnBusy", "" + this.retryTimeOnBusy);
        out.writeAttribute("maxNumberOfThreadsPerEndpoint", "" + this.maxNumberOfThreadsPerEndpoint);
        out.writeEndElement();
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) {
        this.retryTimeOnBusy = Integer.parseInt(token.getAttributeValue("", "retryTimeOnBusy"));
        this.maxNumberOfThreadsPerEndpoint = Integer.parseInt(token.getAttributeValue("", "maxNumberOfThreadsPerEndpoint"));
    }

    @Override
    protected String getElementName() {
        return "byThreadStrategy";
    }

    @Override
    public void init(Router router) {
    }
}

