/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.balancer.AbstractSessionIdExtractor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="jSessionIdExtractor")
public class JSESSIONIDExtractor
extends AbstractSessionIdExtractor {
    private static Logger log = LoggerFactory.getLogger((String)JSESSIONIDExtractor.class.getName());
    Pattern pattern = Pattern.compile(".*JSESSIONID\\s*=([^;]*)");

    @Override
    public String getSessionId(Message msg) throws Exception {
        String cookie = msg.getHeader().getFirstValue("Cookie");
        if (cookie == null) {
            log.debug("no cookie set");
            return null;
        }
        Matcher m = this.pattern.matcher(cookie);
        log.debug("cookie: " + msg.getHeader().getFirstValue("Cookie"));
        if (!m.lookingAt()) {
            return null;
        }
        log.debug("JSESSION cookie found: " + m.group(1).trim());
        return m.group(1).trim();
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("jSessionIdExtractor");
        out.writeEndElement();
    }
}

