/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.balancer.AbstractSessionIdExtractor;
import com.predic8.membrane.core.interceptor.balancer.Balancer;
import com.predic8.membrane.core.interceptor.balancer.BalancerUtil;
import com.predic8.membrane.core.interceptor.balancer.Cluster;
import com.predic8.membrane.core.interceptor.balancer.DispatchingStrategy;
import com.predic8.membrane.core.interceptor.balancer.EmptyNodeListException;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.interceptor.balancer.NodeOnlineChecker;
import com.predic8.membrane.core.interceptor.balancer.RoundRobinStrategy;
import com.predic8.membrane.core.interceptor.balancer.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="balancer")
public class LoadBalancingInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)LoadBalancingInterceptor.class.getName());
    private DispatchingStrategy strategy = new RoundRobinStrategy();
    private AbstractSessionIdExtractor sessionIdExtractor;
    private boolean failOver = true;
    private final Balancer balancer = new Balancer();
    private NodeOnlineChecker nodeOnlineChecker;

    public LoadBalancingInterceptor() {
        this.name = "Balancer";
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.strategy.init(router);
        if (this.nodeOnlineChecker != null) {
            this.nodeOnlineChecker.init(router);
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Node dispatchedNode;
        if (this.nodeOnlineChecker != null) {
            exc.setProperty("TRACK_NODE_STATUS", true);
            this.nodeOnlineChecker.putNodesBackUp();
        }
        try {
            dispatchedNode = this.getDispatchedNode(exc);
        }
        catch (EmptyNodeListException e) {
            log.error("No Node found.");
            exc.setResponse(Response.internalServerError().build());
            return Outcome.ABORT;
        }
        dispatchedNode.incCounter();
        dispatchedNode.addThread();
        exc.setProperty("dispatchedNode", dispatchedNode);
        exc.setOriginalRequestUri(dispatchedNode.getDestinationURL(exc));
        exc.getDestinations().clear();
        exc.getDestinations().add(dispatchedNode.getDestinationURL(exc));
        this.setFailOverNodes(exc, dispatchedNode);
        return Outcome.CONTINUE;
    }

    @Override
    public void handleAbort(Exchange exc) {
        if (this.nodeOnlineChecker != null) {
            this.nodeOnlineChecker.handle(exc);
        }
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        String sessionId;
        if (this.nodeOnlineChecker != null) {
            this.nodeOnlineChecker.handle(exc);
        }
        if (this.sessionIdExtractor != null && (sessionId = this.getSessionId(exc.getResponse())) != null) {
            this.balancer.addSession2Cluster(sessionId, BalancerUtil.getSingleClusterNameOrDefault(this.balancer), (Node)exc.getProperty("dispatchedNode"));
        }
        this.updateDispatchedNode(exc);
        this.strategy.done(exc);
        return Outcome.CONTINUE;
    }

    private void setFailOverNodes(Exchange exc, Node dispatchedNode) {
        if (!this.failOver) {
            return;
        }
        for (Node ep : this.getEndpoints()) {
            if (ep.equals(dispatchedNode)) continue;
            exc.getDestinations().add(ep.getDestinationURL(exc));
        }
    }

    private void updateDispatchedNode(Exchange exc) {
        Node n = (Node)exc.getProperty("dispatchedNode");
        n.removeThread();
        exc.setTimeResSent(System.currentTimeMillis());
        n.collectStatisticsFrom(exc);
    }

    private Node getDispatchedNode(Exchange exc) throws Exception {
        String sessionId;
        if (this.sessionIdExtractor == null || (sessionId = this.getSessionId(exc.getRequest())) == null) {
            log.debug("no session id found.");
            return this.strategy.dispatch(this, exc);
        }
        Session s = this.getSession(sessionId);
        if (s == null) {
            log.debug("no session found for id " + sessionId);
        }
        if (s == null || s.getNode().isDown()) {
            log.debug("assigning new node for session id " + sessionId + (String)(s != null ? " (old node was " + s.getNode() + ")" : ""));
            this.balancer.addSession2Cluster(sessionId, BalancerUtil.getSingleClusterNameOrDefault(this.balancer), this.strategy.dispatch(this, exc));
        }
        s = this.getSession(sessionId);
        s.used();
        return s.getNode();
    }

    private Session getSession(String sessionId) {
        return this.balancer.getSessions(BalancerUtil.getSingleClusterNameOrDefault(this.balancer)).get(sessionId);
    }

    private String getSessionId(Message msg) throws Exception {
        return this.sessionIdExtractor.getSessionId(msg);
    }

    @MCAttribute
    public void setName(String name) throws Exception {
        this.balancer.setName(name);
    }

    public String getName() {
        return this.balancer.getName();
    }

    public DispatchingStrategy getDispatchingStrategy() {
        return this.strategy;
    }

    @MCChildElement(order=3)
    public void setDispatchingStrategy(DispatchingStrategy strategy) {
        this.strategy = strategy;
    }

    public List<Node> getEndpoints() {
        return this.balancer.getAvailableNodesByCluster(BalancerUtil.getSingleClusterNameOrDefault(this.balancer));
    }

    public AbstractSessionIdExtractor getSessionIdExtractor() {
        return this.sessionIdExtractor;
    }

    @MCChildElement(order=4)
    public void setNodeOnlineChecker(NodeOnlineChecker noc) {
        this.nodeOnlineChecker = noc;
        this.nodeOnlineChecker.setLbi(this);
    }

    public NodeOnlineChecker getNodeOnlineChecker() {
        return this.nodeOnlineChecker;
    }

    @MCChildElement(order=1)
    public void setSessionIdExtractor(AbstractSessionIdExtractor sessionIdExtractor) {
        this.sessionIdExtractor = sessionIdExtractor;
    }

    public boolean isFailOver() {
        return this.failOver;
    }

    public void setFailOver(boolean failOver) {
        this.failOver = failOver;
    }

    public Balancer getClusterManager() {
        return this.balancer;
    }

    @MCChildElement(order=2)
    public void setClustersFromSpring(List<Balancer> balancers) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (Balancer balancer : balancers) {
            clusters.addAll(balancer.getClusters());
        }
        this.balancer.setClusters(clusters);
    }

    public List<Balancer> getClustersFromSpring() {
        return new ArrayList<Balancer>((Collection)Lists.newArrayList((Object[])new Balancer[]{this.balancer})){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean add(Balancer e) {
                LoadBalancingInterceptor.this.balancer.setClusters(e.getClusters());
                return super.add(e);
            }

            @Override
            public Balancer set(int index, Balancer element) {
                LoadBalancingInterceptor.this.balancer.setClusters(element.getClusters());
                return super.set(index, element);
            }
        };
    }

    public long getSessionTimeout() {
        return this.balancer.getSessionTimeout();
    }

    @MCAttribute
    public void setSessionTimeout(long sessionTimeout) {
        this.balancer.setSessionTimeout(sessionTimeout);
    }

    @Override
    public String getShortDescription() {
        return "Performs load-balancing between <a href=\"/admin/balancers\">several nodes</a>.";
    }

    @Override
    public void init() throws Exception {
        for (Cluster c : this.balancer.getClusters()) {
            for (Node n : c.getNodes()) {
                c.nodeUp(n);
            }
        }
    }
}

