/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.interceptor.balancer.DispatchingStrategy;
import com.predic8.membrane.core.interceptor.balancer.EmptyNodeListException;
import com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor;
import com.predic8.membrane.core.interceptor.balancer.Node;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@MCElement(name="roundRobinStrategy")
public class RoundRobinStrategy
extends AbstractXmlElement
implements DispatchingStrategy {
    private int last = -1;

    @Override
    public void done(AbstractExchange exc) {
    }

    @Override
    public synchronized Node dispatch(LoadBalancingInterceptor interceptor, AbstractExchange exc) throws EmptyNodeListException {
        List<Node> endpoints = interceptor.getEndpoints();
        if (endpoints.isEmpty()) {
            throw new EmptyNodeListException();
        }
        int i = this.incrementAndGet(endpoints.size());
        return endpoints.get(i);
    }

    private synchronized int incrementAndGet(int numEndpoints) {
        ++this.last;
        if (this.last >= numEndpoints) {
            this.last = 0;
        }
        return this.last;
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("roundRobinStrategy");
        out.writeEndElement();
    }

    @Override
    protected String getElementName() {
        return "roundRobinStrategy";
    }

    @Override
    public void init(Router router) {
    }
}

