/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer.faultmonitoring;

import com.predic8.membrane.core.interceptor.balancer.faultmonitoring.NodeFaultProfile;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FaultMonitoringState {
    private static Log log = LogFactory.getLog((String)FaultMonitoringState.class.getName());
    private final ConcurrentMap<String, NodeFaultProfile> map = new ConcurrentHashMap<String, NodeFaultProfile>();
    private Timer timer;

    public ConcurrentMap<String, NodeFaultProfile> getMap() {
        return this.map;
    }

    public synchronized void scheduleRemoval(final long clearFaultyProfilesByTimerAfterLastFailureSeconds, long clearFaultyTimerIntervalSeconds) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    Iterator iterator = FaultMonitoringState.this.map.values().iterator();
                    while (iterator.hasNext()) {
                        NodeFaultProfile current = (NodeFaultProfile)iterator.next();
                        long lastFailureTimestamp = current.getLastFailureTimestamp();
                        long diff = System.currentTimeMillis() - lastFailureTimestamp;
                        if (diff < clearFaultyProfilesByTimerAfterLastFailureSeconds) continue;
                        iterator.remove();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected exception when running maintenance timer", (Throwable)e);
                }
            }
        }, clearFaultyTimerIntervalSeconds, clearFaultyTimerIntervalSeconds);
    }
}

