/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer.faultmonitoring;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.interceptor.balancer.DispatchingStrategy;
import com.predic8.membrane.core.interceptor.balancer.EmptyNodeListException;
import com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.interceptor.balancer.faultmonitoring.FaultMonitoringState;
import com.predic8.membrane.core.interceptor.balancer.faultmonitoring.NodeFaultProfile;
import com.predic8.membrane.core.transport.http.HttpClientStatusEventBus;
import com.predic8.membrane.core.transport.http.HttpClientStatusEventListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@MCElement(name="faultMonitoringStrategy")
public class FaultMonitoringStrategy
extends AbstractXmlElement
implements DispatchingStrategy {
    private static Log log = LogFactory.getLog((String)FaultMonitoringStrategy.class.getName());
    private double minFlawlessServerRatioForRoundRobin = 0.5;
    private long clearFaultyProfilesByTimerAfterLastFailureSeconds = 300000L;
    private long clearFaultyTimerIntervalSeconds = 30000L;
    private final FaultMonitoringState state = new FaultMonitoringState();
    private final Random random = new Random();
    private HttpClientStatusEventBus httpClientStatusEventBus;
    private int last = -1;

    @Override
    public void init(Router router) {
        this.httpClientStatusEventBus = new HttpClientStatusEventBus();
        this.httpClientStatusEventBus.registerListener(new MyHttpClientStatusEventListener());
        this.state.scheduleRemoval(this.clearFaultyProfilesByTimerAfterLastFailureSeconds, this.clearFaultyTimerIntervalSeconds);
    }

    private List<Node> filterBySuccessProfile(List<Node> endpoints) {
        if (this.state.getMap().isEmpty()) {
            return endpoints;
        }
        ArrayList<Node> filtered = new ArrayList<Node>(endpoints.size());
        for (Node endpoint : endpoints) {
            NodeFaultProfile nodeFaultProfile = (NodeFaultProfile)this.state.getMap().get(this.makeHostAndPort(endpoint));
            if (nodeFaultProfile != null && nodeFaultProfile.getScore() < 1.0) continue;
            filtered.add(endpoint);
        }
        return filtered;
    }

    private String makeHostAndPort(Node endpoint) {
        return endpoint.getHost() + ":" + endpoint.getPort();
    }

    @Override
    public void done(AbstractExchange exc) {
    }

    @Override
    public synchronized Node dispatch(LoadBalancingInterceptor interceptor, AbstractExchange exc) throws EmptyNodeListException {
        double ratio;
        exc.setProperty("HttpClientStatusEventBus", this.httpClientStatusEventBus);
        List<Node> endpoints = interceptor.getEndpoints();
        if (endpoints.isEmpty()) {
            throw new EmptyNodeListException();
        }
        if (endpoints.size() == 1) {
            return endpoints.get(0);
        }
        List<Node> endpointsFiltered = this.filterBySuccessProfile(endpoints);
        if (endpointsFiltered.size() >= 1 && (ratio = (double)endpointsFiltered.size() / (double)endpoints.size()) >= this.minFlawlessServerRatioForRoundRobin) {
            log.trace((Object)("Selecting round robin for " + endpointsFiltered.size() + "/" + endpoints.size() + " endpoints."));
            return this.applyRoundRobinStrategy(endpointsFiltered);
        }
        log.trace((Object)"Selecting by chance");
        return this.returnByChance(endpoints);
    }

    private Node returnByChance(List<Node> endpoints) {
        assert (endpoints.size() >= 2);
        double[] scores = new double[endpoints.size()];
        double totalScore = 0.0;
        for (int i = 0; i < endpoints.size(); ++i) {
            double score;
            Node endpoint = endpoints.get(i);
            NodeFaultProfile nodeFaultProfile = (NodeFaultProfile)this.state.getMap().get(this.makeHostAndPort(endpoint));
            if (nodeFaultProfile == null) {
                score = 1.0;
            } else {
                score = nodeFaultProfile.getScore();
                if (score == 0.0) {
                    score = 1.0E-4;
                }
            }
            scores[i] = totalScore += score;
        }
        double chosen = this.random.nextDouble() * totalScore;
        int selected = 0;
        while (chosen > scores[selected] && selected + 1 < endpoints.size()) {
            ++selected;
        }
        return endpoints.get(selected);
    }

    private Node applyRoundRobinStrategy(List<Node> endpoints) {
        int i = this.incrementAndGet(endpoints.size());
        return endpoints.get(i);
    }

    private synchronized int incrementAndGet(int numEndpoints) {
        ++this.last;
        if (this.last >= numEndpoints) {
            this.last = 0;
        }
        return this.last;
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("faultMonitoringStrategy");
        out.writeEndElement();
    }

    @Override
    protected String getElementName() {
        return "faultMonitoringStrategy";
    }

    public double getMinFlawlessServerRatioForRoundRobin() {
        return this.minFlawlessServerRatioForRoundRobin;
    }

    @MCAttribute
    public void setMinFlawlessServerRatioForRoundRobin(double minFlawlessServerRatioForRoundRobin) {
        this.minFlawlessServerRatioForRoundRobin = minFlawlessServerRatioForRoundRobin;
    }

    public long getClearFaultyProfilesByTimerAfterLastFailureSeconds() {
        return this.clearFaultyProfilesByTimerAfterLastFailureSeconds;
    }

    @MCAttribute
    public void setClearFaultyProfilesByTimerAfterLastFailureSeconds(long clearFaultyProfilesByTimerAfterLastFailureSeconds) {
        this.clearFaultyProfilesByTimerAfterLastFailureSeconds = clearFaultyProfilesByTimerAfterLastFailureSeconds;
    }

    public long getClearFaultyTimerIntervalSeconds() {
        return this.clearFaultyTimerIntervalSeconds;
    }

    @MCAttribute
    public void setClearFaultyTimerIntervalSeconds(long clearFaultyTimerIntervalSeconds) {
        this.clearFaultyTimerIntervalSeconds = clearFaultyTimerIntervalSeconds;
    }

    private class MyHttpClientStatusEventListener
    implements HttpClientStatusEventListener {
        private MyHttpClientStatusEventListener() {
        }

        @Override
        public void onResponse(long timestamp, String destination, int responseCode) {
            boolean is5xx;
            log.debug((Object)("onResponse for " + destination + " with code " + responseCode + " at time " + timestamp));
            String hostAndPort = this.extractHostAndPort(destination);
            NodeFaultProfile nodeFaultProfile = (NodeFaultProfile)FaultMonitoringStrategy.this.state.getMap().get(hostAndPort);
            boolean bl = is5xx = responseCode >= 500 && responseCode < 600;
            if (!is5xx) {
                if (this.informSuccess(timestamp, nodeFaultProfile)) {
                    FaultMonitoringStrategy.this.state.getMap().remove(hostAndPort);
                    log.debug((Object)("Self-cleared from bad history: " + hostAndPort));
                }
            } else {
                this.informFailure(timestamp, hostAndPort, nodeFaultProfile);
            }
        }

        @Override
        public void onException(long timestamp, String destination, Exception exception) {
            log.debug((Object)("onException for " + destination + " with ex " + exception.getMessage() + " at time " + timestamp));
            String hostAndPort = this.extractHostAndPort(destination);
            NodeFaultProfile nodeFaultProfile = (NodeFaultProfile)FaultMonitoringStrategy.this.state.getMap().get(hostAndPort);
            this.informFailure(timestamp, hostAndPort, nodeFaultProfile);
        }

        private boolean informSuccess(long timestamp, NodeFaultProfile nodeFaultProfile) {
            if (nodeFaultProfile == null) {
                return false;
            }
            return nodeFaultProfile.informSuccess(timestamp);
        }

        private void informFailure(long timestamp, String hostAndPort, NodeFaultProfile nodeFaultProfile) {
            if (nodeFaultProfile == null) {
                nodeFaultProfile = new NodeFaultProfile(timestamp);
                FaultMonitoringStrategy.this.state.getMap().putIfAbsent(hostAndPort, nodeFaultProfile);
                log.debug((Object)("Created bad history profile for: " + hostAndPort));
            } else {
                nodeFaultProfile.informFailure(timestamp);
            }
        }

        private String extractHostAndPort(String destination) {
            URI uri;
            try {
                uri = new URI(destination);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return uri.getHost() + ":" + uri.getPort();
        }
    }
}

