/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer.faultmonitoring;

class NodeFaultProfile {
    private volatile long lastFailureTimestamp;
    private volatile double score;

    public NodeFaultProfile(long lastFailureTimestamp) {
        this.lastFailureTimestamp = lastFailureTimestamp;
        this.score = 0.5;
    }

    public boolean informSuccess(long timestamp) {
        if (this.score >= 0.9) {
            this.score = 1.0;
            return true;
        }
        double newScore = this.score + 0.1;
        if (newScore >= 1.0) {
            this.score = 1.0;
            return true;
        }
        this.score = newScore;
        return false;
    }

    public void informFailure(long timestamp) {
        this.lastFailureTimestamp = timestamp;
        this.score /= 2.0;
    }

    public double getScore() {
        double ret = this.score;
        if (ret > 1.0) {
            return 1.0;
        }
        if (ret < 0.0) {
            return 0.0;
        }
        return ret;
    }

    public long getLastFailureTimestamp() {
        return this.lastFailureTimestamp;
    }
}

