/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.cache;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.cache.NegativeNode;
import com.predic8.membrane.core.interceptor.cache.Node;
import com.predic8.membrane.core.interceptor.cache.PositiveNode;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="cache")
public class CacheInterceptor
extends AbstractInterceptor {
    static final Logger log = LoggerFactory.getLogger((String)CacheInterceptor.class.getName());
    private Store store;
    private boolean force = true;
    private HashSet<String> allowedRequestHeaders = new HashSet();
    private HashSet<String> allowedResponseHeaders = new HashSet();

    public CacheInterceptor() {
        this.allowedRequestHeaders.add("host");
        this.allowedRequestHeaders.add("cache-control");
        this.allowedRequestHeaders.add("if-modified-since");
        this.allowedRequestHeaders.add("user-agent");
        this.allowedRequestHeaders.add("accept");
        if (this.force) {
            this.allowedRequestHeaders.add("accept-encoding");
            this.allowedRequestHeaders.add("authorization");
            this.allowedRequestHeaders.add("pragma");
        }
        this.allowedRequestHeaders.add("referer");
        this.allowedResponseHeaders.add("date");
        this.allowedResponseHeaders.add("server");
        this.allowedResponseHeaders.add("last-modified");
        this.allowedResponseHeaders.add("etag");
        this.allowedResponseHeaders.add("accept-ranges");
        this.allowedResponseHeaders.add("content-length");
        this.allowedResponseHeaders.add("age");
        this.allowedResponseHeaders.add("connection");
        this.allowedResponseHeaders.add("vary");
        this.allowedResponseHeaders.add("content-type");
        this.allowedResponseHeaders.add("expires");
        this.allowedResponseHeaders.add("cache-control");
        this.allowedResponseHeaders.add("location");
        this.allowedResponseHeaders.add("link");
        this.allowedResponseHeaders.add("transfer-encoding");
        this.allowedResponseHeaders.add("status");
        this.allowedResponseHeaders.add("content-disposition");
        this.allowedResponseHeaders.add("content-security-policy");
        this.allowedResponseHeaders.add("strict-transport-security");
        this.allowedResponseHeaders.add("via");
        this.allowedResponseHeaders.add("fastly-debug-digest");
        this.allowedResponseHeaders.add("access-control-allow-origin");
        if (this.force) {
            this.allowedResponseHeaders.add("set-cookie");
            this.allowedResponseHeaders.add("docker-distribution-api-version");
            this.allowedResponseHeaders.add("www-authenticate");
            this.allowedResponseHeaders.add("docker-content-digest");
            this.allowedResponseHeaders.add("cookie");
        }
    }

    public Store getStore() {
        return this.store;
    }

    @MCChildElement
    @Required
    public void setStore(Store store) {
        this.store = store;
    }

    @Override
    public void init(Router router) throws Exception {
        this.store.init(router);
    }

    static String toRFC(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date(timestamp));
    }

    static long fromRFC(String timestamp) throws ParseException {
        if (timestamp == null) {
            return 0L;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        return dateFormat.parse(timestamp).getTime();
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        String dest = exc.getDestinations().get(0);
        Node node = this.store.get(dest);
        if (node != null && node.canSatisfy(exc.getRequest())) {
            exc.setResponse(node.toResponse(exc.getRequest()));
            return Outcome.RETURN;
        }
        if (this.canCache(exc.getRequest(), true)) {
            exc.getRequest().getHeader().removeFields("If-Modified-Since");
        }
        return super.handleRequest(exc);
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        try {
            if (this.canCache(exc.getRequest(), false) && this.canCache(exc.getResponse(), true)) {
                String dest = exc.getDestinations().get(0);
                switch (exc.getResponse().getStatusCode()) {
                    case 200: {
                        this.store.put(dest, new PositiveNode(exc));
                        break;
                    }
                    case 401: 
                    case 404: {
                        this.store.put(dest, new NegativeNode(exc));
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 307: {
                        this.store.put(dest, new PositiveNode(exc));
                        break;
                    }
                    default: {
                        log.warn("Could not cache HTTP response because of its status code " + exc.getResponse().getStatusCode() + ".");
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception during cache handling.", (Throwable)e);
        }
        exc.getResponse().getHeader().removeFields(this.name);
        exc.getResponse().getHeader().removeFields("ETag");
        exc.getResponse().getHeader().removeFields("Accept-Ranges");
        exc.getResponse().getHeader().removeFields("Age");
        exc.getResponse().getHeader().removeFields("Connection");
        exc.getResponse().getHeader().removeFields("Vary");
        exc.getResponse().getHeader().removeFields("Expires");
        exc.getResponse().getHeader().removeFields("Cache-Control");
        return super.handleResponse(exc);
    }

    private boolean canCache(Request request, boolean emitWarning) {
        for (HeaderField header : request.getHeader().getAllHeaderFields()) {
            String headerName = header.getHeaderName().toString().toLowerCase(Locale.US);
            if (headerName.startsWith("x-") || this.allowedRequestHeaders.contains(headerName) || headerName.equals("connection") && "close".equals(header.getValue().toLowerCase(Locale.US)) || headerName.equals("connection") && "keep-alive".equals(header.getValue().toLowerCase(Locale.US)) || headerName.equals("accept-encoding") && "identity".equals(header.getValue().toLowerCase(Locale.US))) continue;
            if (emitWarning) {
                log.warn("Could not cache request because of '" + header.getHeaderName() + "' header:\n" + request.getStartLine() + request.getHeader());
            }
            return false;
        }
        return true;
    }

    private boolean canCache(Response response, boolean emitWarning) {
        for (HeaderField header : response.getHeader().getAllHeaderFields()) {
            String headerName = header.getHeaderName().toString().toLowerCase(Locale.US);
            if (headerName.startsWith("x-") || this.allowedResponseHeaders.contains(headerName)) continue;
            if (emitWarning) {
                log.warn("Could not cache response because of '" + header.getHeaderName() + "' header:\n" + response.getStartLine() + response.getHeader());
            }
            return false;
        }
        return true;
    }

    public static abstract class Store {
        public void init(Router router) {
        }

        public abstract Node get(String var1);

        public abstract void put(String var1, Node var2);
    }

    @MCElement(name="fileStore")
    public static class FileStore
    extends Store {
        private String dir;

        public String getDir() {
            return this.dir;
        }

        @MCAttribute
        public void setDir(String dir) {
            this.dir = dir;
        }

        @Override
        public void init(Router router) {
            this.dir = ResolverMap.combine(router.getBaseLocation(), this.dir);
            File d = new File(this.dir);
            if (!d.exists() && !d.mkdirs()) {
                throw new RuntimeException("Could not create directory " + this.dir);
            }
        }

        private String encode(String url) {
            Object res = Base64.encodeBase64String((byte[])url.getBytes(Constants.UTF_8_CHARSET));
            if (((String)res).length() > 120) {
                res = ((String)res).substring(0, 100) + "-" + ((String)res).hashCode();
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node get(String url) {
            Node node;
            File f = new File(this.dir, this.encode(url));
            if (!f.exists()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(f);
            try {
                node = (Node)new ObjectInputStream(fis).readObject();
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("", (Throwable)e);
                    return null;
                }
            }
            fis.close();
            return node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(String url, Node node) {
            File f = new File(this.dir, this.encode(url));
            try (FileOutputStream fos = new FileOutputStream(f);){
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(node);
                oos.close();
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
        }
    }

    @MCElement(name="inMemoryStore")
    public static class InMemoryStore
    extends Store {
        HashMap<String, Node> cache = new HashMap();

        @Override
        public Node get(String url) {
            return this.cache.get(url);
        }

        @Override
        public void put(String url, Node node) {
            this.cache.put(url, node);
        }
    }
}

