/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.cbr;

import com.googlecode.jatl.Html;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.cbr.Case;
import com.predic8.membrane.core.util.SynchronizedXPathFactory;
import com.predic8.membrane.core.util.TextUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@MCElement(name="switch")
public class XPathCBRInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)XPathCBRInterceptor.class.getName());
    private List<Case> cases = new ArrayList<Case>();
    private Map<String, String> namespaces;

    public XPathCBRInterceptor() {
        this.name = "Content Based Router";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest().isBodyEmpty()) {
            return Outcome.CONTINUE;
        }
        Case r = this.findRoute(exc.getRequest());
        if (r == null) {
            return Outcome.CONTINUE;
        }
        log.debug("match found for {" + r.getXPath() + "} routing to {" + r.getUrl() + "}");
        this.updateDestination(exc, r);
        return Outcome.CONTINUE;
    }

    private void updateDestination(Exchange exc, Case r) {
        exc.setOriginalRequestUri(r.getUrl());
        exc.getDestinations().clear();
        exc.getDestinations().add(r.getUrl());
    }

    private Case findRoute(Request request) throws Exception {
        for (Case r : this.cases) {
            InputSource is = new InputSource(request.getBodyAsStreamDecoded());
            is.setEncoding(request.getCharset());
            if (((Boolean)SynchronizedXPathFactory.newXPath(this.namespaces).evaluate(r.getXPath(), is, XPathConstants.BOOLEAN)).booleanValue()) {
                return r;
            }
            log.debug("no match found for xpath {" + r.getXPath() + "}");
        }
        return null;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    @MCChildElement
    @Required
    public void setCases(List<Case> cases) {
        this.cases = cases;
    }

    public List<Case> getCases() {
        return this.cases;
    }

    @Override
    public String getShortDescription() {
        return "Routes incoming requests based on XPath expressions.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append("<br/>");
        StringWriter sw = new StringWriter();
        new Html(sw){
            {
                this.text("The requests are routed based on the following rules:");
                this.table();
                this.thead();
                this.tr();
                ((Html)((Html)this.th()).text("XPath")).end();
                ((Html)((Html)this.th()).text("URL")).end();
                this.end();
                this.end();
                this.tbody();
                for (Case c : XPathCBRInterceptor.this.cases) {
                    this.tr();
                    ((Html)((Html)this.td()).text(c.getXPath())).end();
                    ((Html)((Html)this.td()).raw(TextUtil.linkURL(c.getUrl()))).end();
                    this.end();
                }
                this.end();
                this.end();
            }
        };
        sb.append(sw.toString());
        return sb.toString();
    }
}

