/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.formvalidation;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="formValidation")
public class FormValidationInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)FormValidationInterceptor.class.getName());
    private List<Field> fields = new ArrayList<Field>();

    public FormValidationInterceptor() {
        this.name = "FormValidation";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.logMappings();
        Map<String, String> propMap = URLParamUtil.getParams(this.router.getUriFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        for (Field f : this.fields) {
            if (!propMap.containsKey(f.name) || f.matchesSubstring(propMap.get(f.name))) continue;
            this.setErrorResponse(exc, propMap, f);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    private void setErrorResponse(Exchange exc, Map<String, String> propMap, Field f) {
        exc.setResponse(Response.badRequest("Parameter " + f.name + "=" + propMap.get(f.name) + " didn't match " + f.regex).build());
    }

    private void logMappings() {
        for (Field m : this.fields) {
            log.debug("[regex:" + m.regex + "],[name:" + m.name + "]");
        }
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @MCChildElement
    @Required
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @MCElement(name="field", topLevel=false, id="formValidation-field")
    public static class Field
    extends AbstractXmlElement {
        public String name;
        public String regex;
        private Pattern pattern;

        public boolean matchesSubstring(String input) {
            return this.pattern.matcher(input).matches();
        }

        @Override
        protected void parseAttributes(XMLStreamReader token) throws Exception {
            this.name = token.getAttributeValue("", "name");
            this.setRegex(token.getAttributeValue("", "regex"));
        }

        @Override
        public void write(XMLStreamWriter out) throws XMLStreamException {
            out.writeStartElement("field");
            out.writeAttribute("regex", this.regex);
            out.writeAttribute("name", this.name);
            out.writeEndElement();
        }

        public String getName() {
            return this.name;
        }

        @MCAttribute
        @Required
        public void setName(String name) {
            this.name = name;
        }

        public String getRegex() {
            return this.regex;
        }

        @MCAttribute
        @Required
        public void setRegex(String regex) {
            this.regex = regex;
            this.pattern = Pattern.compile(regex);
        }
    }
}

