/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.gatekeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@MCElement(name="gatekeeper")
public class GateKeeperClientInterceptor
extends AbstractInterceptor {
    private String url;
    private HttpClientConfiguration httpClientConfiguration;
    private HttpClient httpClient;
    private ObjectMapper om = new ObjectMapper();
    Cache<String, Map> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public GateKeeperClientInterceptor() {
        this.name = "gatekeeper";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    public GateKeeperClientInterceptor(String url) {
        this.url = url;
        this.name = "gatekeeper";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.httpClient = router.getHttpClientFactory().createClient(this.httpClientConfiguration);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        String ruleName = exc.getRule().getName();
        String clientIP = exc.getRemoteAddrIp();
        String body = this.om.writeValueAsString((Object)ImmutableMap.builder().put((Object)"rule", (Object)ruleName).put((Object)"clientIP", (Object)clientIP).build());
        Map result = (Map)this.cache.getIfPresent((Object)body);
        if (result == null) {
            result = this.getResult(body);
        }
        if (result.get("error") != null) {
            return this.createResponse(exc);
        }
        boolean gate = (Boolean)result.get("gate");
        if (gate) {
            this.cache.put((Object)body, (Object)result);
            return Outcome.CONTINUE;
        }
        return this.createResponse(exc);
    }

    private Map getResult(String body) throws Exception {
        Exchange exc2 = this.httpClient.call(new Request.Builder().post(this.url).header("Content-Type", "application/json").body(body).buildExchange());
        if (exc2.getResponse().getStatusCode() != 200) {
            return ImmutableMap.of((Object)"error", (Object)("status " + exc2.getResponse().getStatusCode()));
        }
        return ImmutableMap.copyOf((Map)((Map)this.om.readValue(exc2.getResponse().getBodyAsStreamDecoded(), Map.class)));
    }

    private Outcome createResponse(Exchange exc) {
        exc.setResponse(Response.forbidden().build());
        return Outcome.RETURN;
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    @MCChildElement(order=10)
    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }
}

