/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.gatekeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="routerIpResolver")
public class RouterIpResolverInterceptor
extends AbstractInterceptor {
    private final Logger LOG = LoggerFactory.getLogger(RouterIpResolverInterceptor.class);
    private List<String> routerIps = new ArrayList<String>();
    private ObjectMapper om = new ObjectMapper();
    private HttpClientConfiguration httpClientConfiguration;
    private SSLParser sslParser;
    private HttpClient httpClient;
    private SSLContext sslContext;
    private Outcome errorOutcome = Outcome.ABORT;
    private int port;

    public String getRouterIps() {
        return String.join((CharSequence)",", this.routerIps);
    }

    @MCAttribute
    public void setRouterIps(String routerIps) {
        this.routerIps = Arrays.asList(routerIps.split(","));
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    public int getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public Outcome getErrorOutcome() {
        return this.errorOutcome;
    }

    @MCAttribute
    public void setErrorOutcome(Outcome errorOutcome) {
        this.errorOutcome = errorOutcome;
    }

    @MCChildElement(order=10)
    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement(order=20)
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.httpClient = router.getHttpClientFactory().createClient(this.httpClientConfiguration);
        if (this.sslParser != null) {
            this.sslContext = new StaticSSLContext(this.sslParser, router.getResolverMap(), router.getBaseLocation());
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        String remoteIp = exc.getRemoteAddrIp();
        if (!this.routerIps.contains(remoteIp)) {
            return Outcome.CONTINUE;
        }
        try {
            int port = ((HttpServerHandler)exc.getHandler()).getSourceSocket().getPort();
            this.LOG.debug("remoteIp is a router, resolving port=" + port + " ip=" + exc.getRemoteAddrIp());
            String body = this.om.writeValueAsString((Object)ImmutableMap.of((Object)"port", (Object)port, (Object)"ip", (Object)exc.getRemoteAddrIp()));
            Exchange exchange = new Request.Builder().post("https://" + remoteIp + (String)(this.port == 0 ? "" : ":" + this.port)).body(body).buildExchange();
            if (this.sslContext != null) {
                exchange.setProperty("SSL_CONTEXT", this.sslContext);
            }
            Response r = this.httpClient.call(exchange).getResponse();
            String res = r.getBodyAsStringDecoded();
            if (r.getStatusCode() != 200) {
                this.LOG.warn("Error during remote IP lookup on router " + remoteIp);
                return this.errorOutcome;
            }
            remoteIp = (String)((Map)this.om.readValue(res, Map.class)).get("ip");
            exc.setRemoteAddrIp(remoteIp);
            return Outcome.CONTINUE;
        }
        catch (Exception e) {
            this.LOG.error("", (Throwable)e);
            return this.errorOutcome;
        }
    }
}

