/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.groovy;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.lang.AbstractScriptInterceptor;
import com.predic8.membrane.core.lang.groovy.GroovyLanguageSupport;
import com.predic8.membrane.core.rules.ServiceProxy;
import com.predic8.membrane.core.util.TextUtil;
import java.util.NoSuchElementException;
import org.apache.commons.text.StringEscapeUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="groovy", mixed=true)
public class GroovyInterceptor
extends AbstractScriptInterceptor {
    Logger log = LoggerFactory.getLogger(GroovyInterceptor.class);

    public GroovyInterceptor() {
        this.name = "Groovy";
    }

    @Override
    protected void initInternal() {
        try {
            this.script = new GroovyLanguageSupport().compileScript(this.router.getBackgroundInitializator(), null, this.src);
        }
        catch (MultipleCompilationErrorsException e) {
            this.logGroovyException((Exception)((Object)e));
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logGroovyException(Exception e) {
        try {
            Object rule = this.getRule();
            if (rule instanceof ServiceProxy) {
                ServiceProxy sp = (ServiceProxy)rule;
                this.log.error("Exception in Groovy script in service proxy '" + sp.getName() + "' on port " + sp.getPort() + " with path " + (sp.getPath() != null ? sp.getPath().getValue() : "*"));
            } else {
                this.log.error("Exception in Groovy script in service proxy '" + rule.getName() + "'");
            }
            this.log.error("There is possibly a syntax error in the groovy script (compilation error)");
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            e.printStackTrace();
        }
    }

    @Override
    public String getShortDescription() {
        return "Executes a groovy script.";
    }

    @Override
    public String getLongDescription() {
        return TextUtil.removeFinalChar(this.getShortDescription()) + ":<br/><pre style=\"overflow-x:auto\">" + StringEscapeUtils.escapeHtml4((String)TextUtil.removeCommonLeadingIndentation(this.src)) + "</pre>";
    }
}

