/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.groovy;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.groovy.GroovyInterceptor;

@MCElement(name="groovyTemplate", mixed=true)
public class GroovyTemplateInterceptor
extends AbstractInterceptor {
    String src = "";
    GroovyInterceptor groovyInterceptor;

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.groovyInterceptor = new GroovyInterceptor();
        this.groovyInterceptor.setSrc(this.createGroovyScript());
        this.groovyInterceptor.init(router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.groovyInterceptor.handleRequest(exc);
        String html = (String)exc.getProperty("GROOVY_TEMPLATE");
        exc.setResponse(Response.ok(html).contentType("text/html;charset=UTF-8").build());
        return Outcome.RETURN;
    }

    private String createGroovyScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("import groovy.text.markup.*").append("\n").append("def markupEngine = new MarkupTemplateEngine()").append("\n").append("def writer = new StringWriter()").append("\n").append("def markup = '''").append(this.src).append("'''").append("\n").append("def output = markupEngine.createTemplate(markup).make(['spring':spring, 'exc':exc,'flow':flow]).writeTo(writer)").append("\n").append("exc.setProperty('GROOVY_TEMPLATE',output.toString())").append("\n").append("CONTINUE");
        return sb.toString();
    }

    public String getSrc() {
        return this.src;
    }

    @MCTextContent
    public void setSrc(String src) {
        this.src = src;
    }
}

