/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.javascript;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.javascript.GraalVMJavascriptLanguageAdapter;
import com.predic8.membrane.core.interceptor.javascript.JavascriptInterceptor;
import com.predic8.membrane.core.interceptor.javascript.RhinoJavascriptLanguageAdapter;
import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.util.ExitException;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageAdapter {
    private static final Logger log = LoggerFactory.getLogger(JavascriptInterceptor.class);
    protected LanguageSupport languageSupport;
    protected Router router;

    public LanguageAdapter(Router router) {
        this.router = router;
    }

    public static LanguageAdapter instance(Router router) {
        try {
            Class.forName("org.graalvm.polyglot.Context");
            log.info("Found GraalVM Javascript engine.");
            return new GraalVMJavascriptLanguageAdapter(router);
        }
        catch (Exception exception) {
            try {
                Class.forName("org.mozilla.javascript.engine.RhinoScriptEngine");
                log.info("Found Rhino Javascript engine.");
                return new RhinoJavascriptLanguageAdapter(router);
            }
            catch (Exception exception2) {
                throw new ExitException("Fatal Error: No Javascript Engine!\n\nMembrane is configured to use Javascript, maybe in the proxies.xml file.\nThe needed Javascript engine is not shipped with Membrane to spare size\nand to avoid security risks. However you can easiliy install an engine.\n\nWe recommend to install the GraalVM Javascript Engine:\n\n1.) Download:\n\nhttps://repo1.maven.org/maven2/org/graalvm/js/js-scriptengine/22.3.0/js-scriptengine-22.3.0-javadoc.jar\n\n2.) Drop the JAR-file into MEMBRANE_HOME/libs\n3.) Start Membrane.\n\nBut you can also use the old Rhino Engine:\n\nhttps://repo1.maven.org/maven2/org/mozilla/rhino-engine/");
            }
        }
    }

    public Function<Map<String, Object>, Object> compileScript(String script) throws IOException, ClassNotFoundException {
        return this.languageSupport.compileScript(this.router.getBackgroundInitializator(), this.router.getBeanFactory().getClassLoader(), this.prepareScript(script));
    }

    protected abstract String prepareScript(String var1);
}

