/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.xpath.XPathExpressionException;

@MCElement(name="jsonPointerExtractor")
public class JsonPointerExtractorInterceptor
extends AbstractInterceptor {
    private List<Property> properties = new ArrayList<Property>();
    private ObjectMapper mapper = new ObjectMapper();

    public JsonPointerExtractorInterceptor() {
        this.name = "JsonPointer";
    }

    @MCChildElement(order=100)
    @Required
    public void setMappings(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getMappings() {
        return this.properties;
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handleInternal(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleInternal(exc, exc.getResponse());
    }

    private Outcome handleInternal(Exchange exc, Message msg) throws IOException {
        if (!msg.isJSON()) {
            return Outcome.CONTINUE;
        }
        this.setProperties(exc, msg.getBodyAsStream());
        return Outcome.CONTINUE;
    }

    private JsonNode parseJson(InputStream body) throws IOException {
        return this.mapper.readTree(body);
    }

    private void setProperties(Exchange exc, InputStream body) throws IOException {
        JsonNode parsed = this.parseJson(body);
        for (Property m : this.properties) {
            exc.setProperty(m.getName(), this.convertPointedValue(parsed, m));
        }
    }

    private Object convertPointedValue(JsonNode root, Property m) {
        JsonNode pointed = root.at(m.getJsonPointer());
        if (pointed.isArray()) {
            return StreamSupport.stream(pointed.spliterator(), false).filter(n -> !n.isContainerNode()).map(JsonNode::asText).collect(Collectors.toList());
        }
        return pointed.asText();
    }

    @MCElement(name="property", topLevel=false, id="jsonpointer-map")
    public static class Property {
        String jsonPointer;
        String name;

        public Property() {
        }

        public Property(String jsonPointer, String name) throws XPathExpressionException {
            this.name = name;
            this.jsonPointer = jsonPointer;
        }

        public String getJsonPointer() {
            return this.jsonPointer;
        }

        @MCAttribute
        @Required
        public void setJsonPointer(String jsonPointer) throws XPathExpressionException {
            this.jsonPointer = jsonPointer;
        }

        public String getName() {
            return this.name;
        }

        @MCAttribute
        @Required
        public void setName(String name) {
            this.name = name;
        }
    }
}

