/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.jwt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.security.Blob;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@MCElement(name="jwks")
public class Jwks {
    List<Jwk> jwks;
    String jwksUris;

    public List<Jwk> getJwks() {
        return this.jwks;
    }

    @MCChildElement
    public Jwks setJwks(List<Jwk> jwks) {
        this.jwks = jwks;
        return this;
    }

    public String getJwksUris() {
        return this.jwksUris;
    }

    @MCAttribute
    public Jwks setJwksUris(String jwksUris) {
        this.jwksUris = jwksUris;
        return this;
    }

    public void init(ResolverMap resolverMap, String baseLocation) {
        if (this.jwksUris == null || this.jwksUris.isEmpty()) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        for (String uri : this.jwksUris.split(" ")) {
            try {
                for (Object jwkRaw : this.parseJwksUriIntoList(resolverMap, baseLocation, mapper, uri)) {
                    Jwk jwk = new Jwk();
                    jwk.setContent(mapper.writeValueAsString(jwkRaw));
                    this.jwks.add(jwk);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List parseJwksUriIntoList(ResolverMap resolverMap, String baseLocation, ObjectMapper mapper, String uri) throws IOException {
        return (List)((Map)mapper.readValue(resolverMap.resolve(ResolverMap.combine(baseLocation, uri)), Map.class)).get("keys");
    }

    @MCElement(name="jwk", mixed=true, topLevel=false, id="jwks-jwk")
    public static class Jwk
    extends Blob {
        String kid;

        public String getKid() {
            return this.kid;
        }

        @MCAttribute
        public Jwk setKid(String kid) {
            this.kid = kid;
            return this;
        }

        public String getJwk(ResolverMap resolverMap, String baseLocation, ObjectMapper mapper) throws IOException {
            String maybeJwk = this.get(resolverMap, baseLocation);
            Map mapped = (Map)mapper.readValue(maybeJwk, Map.class);
            if (mapped.containsKey("keys")) {
                return this.handleJwks(mapper, mapped);
            }
            return maybeJwk;
        }

        private String handleJwks(ObjectMapper mapper, Map<String, Object> mapped) {
            return ((List)mapped.get("keys")).stream().filter(m -> m.get("kid").toString().equals(this.kid)).map(m -> {
                try {
                    return mapper.writeValueAsString(m);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).findFirst().get();
        }
    }
}

