/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.kubernetes;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.kubernetes.model.AdmissionResponse;
import com.predic8.membrane.core.interceptor.kubernetes.model.AdmissionReview;
import com.predic8.membrane.core.interceptor.kubernetes.model.JSONValidatorError;
import com.predic8.membrane.core.interceptor.kubernetes.model.ResponseStatus;
import com.predic8.membrane.core.interceptor.schemavalidation.IValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.JSONValidator;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@MCElement(name="kubernetesValidation")
public class KubernetesValidationInterceptor
extends AbstractInterceptor {
    private ResolverMap resourceResolver;
    private List<String> resources;
    private ConcurrentMap<String, IValidator> validators = new ConcurrentHashMap<String, IValidator>();
    private List<String> namespaces = ImmutableList.of((Object)"membrane-soa");

    @Override
    public void init(Router router) throws Exception {
        this.resourceResolver = router.getResolverMap();
        super.init(router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest().isBodyEmpty()) {
            return Outcome.CONTINUE;
        }
        ObjectMapper mapper = new ObjectMapper();
        AdmissionReview review = (AdmissionReview)mapper.readValue((Reader)new BufferedReader(new InputStreamReader(exc.getRequest().getBodyAsStreamDecoded(), Charset.forName(exc.getRequest().getCharset()))), AdmissionReview.class);
        Map<String, Object> object = review.getRequest().getObject();
        if (object != null) {
            String requestKind = (String)object.get("kind");
            IValidator validator = this.validators.computeIfAbsent(requestKind.toLowerCase(), schema -> {
                try {
                    return new JSONValidator(this.resourceResolver, "classpath:/com/predic8/membrane/core/config/kubernetes/" + schema + ".schema.json", null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            validator.validateMessage(exc, exc.getRequest(), "request");
        }
        this.setExchangeResponse(exc, mapper, review);
        return Outcome.RETURN;
    }

    private void setExchangeResponse(Exchange exc, ObjectMapper mapper, AdmissionReview review) throws Exception {
        AdmissionResponse response = new AdmissionResponse(review.getRequest().getUid());
        review.setResponse(response);
        if (exc.getResponse() == null) {
            response.setAllowed(true);
        } else {
            response.setAllowed(false);
            List<String> errors = ((JSONValidatorError)mapper.readValue(exc.getResponse().getBody().toString(), JSONValidatorError.class)).getErrors();
            response.setStatus(new ResponseStatus(String.join((CharSequence)", ", errors)));
        }
        review.setRequest(null);
        exc.setResponse(Response.ok(mapper.writeValueAsString((Object)review)).build());
    }

    @MCAttribute
    public void setResources(String resources) {
        this.resources = Arrays.asList(resources.split(","));
    }

    public String getResources() {
        return String.join((CharSequence)",", this.resources);
    }

    public List<String> getResourcesList() {
        return this.resources;
    }

    public List<String> getNamespacesList() {
        return this.namespaces;
    }

    public String getNamespaces() {
        return String.join((CharSequence)",", this.namespaces);
    }

    @MCAttribute
    public void setNamespaces(String namespaces) {
        this.namespaces = Arrays.asList(namespaces.split(","));
    }
}

