/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.misc;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.HttpUtil;

@MCElement(name="return")
public class ReturnInterceptor
extends AbstractInterceptor {
    private int statusCode = 200;
    private String contentType = null;

    @MCAttribute
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @MCAttribute
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        exc.setResponse(new Response.ResponseBuilder().status(this.statusCode, HttpUtil.getMessageForStatusCode(this.statusCode)).contentType(this.getContentType(exc)).bodyEmpty().build());
        return Outcome.RETURN;
    }

    private String getContentType(Exchange exc) {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (exc.getRequest().getHeader().getContentType() != null) {
            return exc.getRequest().getHeader().getContentType();
        }
        return "text/plain";
    }

    @Override
    public String getDisplayName() {
        return "Return";
    }

    @Override
    public String getShortDescription() {
        return String.format("Sends an response with a status code of %d and an content type of %s.", this.statusCode, this.contentType);
    }
}

