/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.misc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@MCElement(name="setHeader")
public class SetHeaderInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)SetHeaderInterceptor.class.getName());
    ObjectMapper om = new ObjectMapper();
    private final Pattern expressionPattern = Pattern.compile("\\$\\{(.*?)}");
    private final ExpressionParser parser = new SpelExpressionParser();
    private String name;
    private String value;

    public String getName() {
        return this.name;
    }

    @MCAttribute
    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    @MCAttribute
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getResponse());
    }

    private Outcome handleMessage(Exchange exchange, Message msg) {
        msg.getHeader().setValue(this.name, this.evaluateExpression(this.getEvalContext(exchange, msg)));
        return Outcome.CONTINUE;
    }

    private StandardEvaluationContext getEvalContext(Exchange exchange, Message msg) {
        EvalContext ctx = new EvalContext();
        ctx.setExchange(exchange);
        ctx.setProperties(exchange.getProperties());
        ctx.setMessage(msg);
        ctx.setHeaders(msg.getHeader());
        return new StandardEvaluationContext((Object)ctx);
    }

    protected String evaluateExpression(StandardEvaluationContext evalCtx) {
        return this.expressionPattern.matcher(this.value).replaceAll(m -> this.evaluateSingeExpression(evalCtx, m.group(1)));
    }

    protected String evaluateSingeExpression(StandardEvaluationContext evalCtx, String expression) {
        String result = (String)this.parser.parseExpression(expression).getValue((EvaluationContext)evalCtx, String.class);
        if (result != null) {
            return result;
        }
        log.info("The expression {} evaluates to null or there is an error in the expression.", (Object)expression);
        return "null";
    }

    @Override
    public String getDisplayName() {
        return "setHeader";
    }

    @Override
    public String getShortDescription() {
        return String.format("Sets the value of the HTTP header '%s' to %s.", this.name, this.value);
    }

    class EvalContext {
        Exchange exchange;
        Message message;
        Header headers;
        Map<String, Object> properties;

        EvalContext() {
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Header getHeaders() {
            return this.headers;
        }

        public void setHeaders(Header headers) {
            this.headers = headers;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public void setExchange(Exchange exchange) {
            this.exchange = exchange;
        }

        public Message getMessage() {
            return this.message;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public Map getJson() throws IOException {
            return (Map)SetHeaderInterceptor.this.om.readValue(this.message.getBodyAsStreamDecoded(), Map.class);
        }
    }
}

