/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.predic8.membrane.core.exchange.Exchange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;

public class CookieUtil {
    public static String stripAndExtractCookiesSorted(Exchange exc, String ownCookieName) throws Exception {
        String[] cookies = CookieUtil.getCookieHeaderSplit(exc);
        if (cookies == null) {
            throw new Exception("Cookie is missing");
        }
        ArrayList<String> newCookies = CookieUtil.removeOwnCookieNameFromCookieHeader(ownCookieName, cookies);
        Collections.sort(newCookies);
        StringBuilder builder = new StringBuilder();
        for (String cookie : newCookies) {
            builder.append(";").append(cookie.trim());
        }
        builder.deleteCharAt(0);
        return builder.toString();
    }

    private static ArrayList<String> removeOwnCookieNameFromCookieHeader(String ownCookieName, String[] cookies) {
        ArrayList<String> newCookies = new ArrayList<String>();
        for (String cookie : cookies) {
            if (cookie.trim().startsWith(ownCookieName)) continue;
            newCookies.add(cookie.trim());
        }
        return newCookies;
    }

    private static String[] getCookieHeaderSplit(Exchange exc) {
        try {
            return exc.getRequest().getHeader().getFirstValue("Cookie").split(Pattern.quote(";"));
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

