/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.AccountBlocker;
import com.predic8.membrane.core.interceptor.authentication.session.CleanupThread;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import com.predic8.membrane.core.interceptor.oauth2.ClaimList;
import com.predic8.membrane.core.interceptor.oauth2.ClientList;
import com.predic8.membrane.core.interceptor.oauth2.ConsentPageFile;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Statistics;
import com.predic8.membrane.core.interceptor.oauth2.SessionFinder;
import com.predic8.membrane.core.interceptor.oauth2.WellknownFile;
import com.predic8.membrane.core.interceptor.oauth2.processors.AuthEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.CertsEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.DefaultEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EmptyEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.FaviconEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.InvalidMethodProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.LoginDialogEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.OAuth2Processors;
import com.predic8.membrane.core.interceptor.oauth2.processors.RevocationEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.TokenEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.UserinfoEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.processors.WellknownEndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.BearerTokenGenerator;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.TokenGenerator;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="oauth2authserver")
public class OAuth2AuthorizationServerInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)OAuth2AuthorizationServerInterceptor.class.getName());
    private String issuer;
    private String location;
    private String basePath;
    private String path = "/login/";
    private String message;
    private String consentFile;
    private boolean exposeUserCredentialsToSession;
    private boolean loginViewDisabled = false;
    private boolean issueNonSpecIdTokens = false;
    private boolean issueNonSpecRefreshTokens = false;
    private Router router;
    private UserDataProvider userDataProvider;
    private SessionManager sessionManager = new SessionManager();
    private AccountBlocker accountBlocker;
    private ClientList clientList;
    private TokenGenerator tokenGenerator = new BearerTokenGenerator();
    private TokenGenerator refreshTokenGenerator = new BearerTokenGenerator();
    private ClaimList claimList;
    private OAuth2Statistics statistics;
    private JwtGenerator jwtGenerator;
    private OAuth2Processors processors = new OAuth2Processors();
    private HashSet<String> supportedAuthorizationGrants = new HashSet();
    private SessionFinder sessionFinder = new SessionFinder();
    private WellknownFile wellknownFile = new WellknownFile();
    private ConsentPageFile consentPageFile = new ConsentPageFile();

    @Override
    public void init(Router router) throws Exception {
        this.name = "OAuth 2 Authorization Server";
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE);
        this.setRouter(router);
        this.basePath = this.computeBasePath();
        if (this.basePath.endsWith("/")) {
            throw new RuntimeException("When <oauth2AuthorizationServer> is nested in a <serviceProxy> with a <path>, the path should not end in a '/'.");
        }
        this.addSupportedAuthorizationGrants();
        this.getWellknownFile().init(router, this);
        this.getConsentPageFile().init(router, this.getConsentFile());
        if (this.userDataProvider == null) {
            throw new Exception("No userDataProvider configured. - Cannot work without one.");
        }
        if (this.getClientList() == null) {
            throw new Exception("No clientList configured. - Cannot work without one.");
        }
        if (this.getClaimList() == null) {
            throw new Exception("No scopeList configured. - Cannot work without one");
        }
        if (this.getLocation() == null) {
            log.warn("===========================================================================================");
            log.warn("IMPORTANT: No location configured - Authorization code and implicit flows are not available");
            log.warn("===========================================================================================");
            this.loginViewDisabled = true;
        }
        if (this.getConsentFile() == null && !this.isLoginViewDisabled()) {
            log.warn("==============================================================================================");
            log.warn("IMPORTANT: No consentFile configured - Authorization code and implicit flows are not available");
            log.warn("==============================================================================================");
            this.loginViewDisabled = true;
        }
        if (this.getPath() == null) {
            throw new Exception("No path configured. - Cannot work without one");
        }
        this.userDataProvider.init(router);
        this.getClientList().init(router);
        this.getClaimList().init(router);
        this.jwtGenerator = new JwtGenerator();
        this.sessionManager.init(router);
        this.statistics = new OAuth2Statistics();
        this.addDefaultProcessors();
        new CleanupThread(this.sessionManager, this.accountBlocker).start();
    }

    private void addDefaultProcessors() {
        this.getProcessors().add(new InvalidMethodProcessor(this)).add(new FaviconEndpointProcessor(this)).add(new AuthEndpointProcessor(this)).add(new TokenEndpointProcessor(this)).add(new UserinfoEndpointProcessor(this)).add(new RevocationEndpointProcessor(this)).add(new LoginDialogEndpointProcessor(this)).add(new WellknownEndpointProcessor(this)).add(new CertsEndpointProcessor(this)).add(new EmptyEndpointProcessor(this)).add(new DefaultEndpointProcessor(this));
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Outcome outcome = this.getProcessors().runProcessors(exc);
        if (outcome != Outcome.CONTINUE) {
            this.sessionManager.postProcess(exc);
        }
        return outcome;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        this.sessionManager.postProcess(exc);
        return super.handleResponse(exc);
    }

    public UserDataProvider getUserDataProvider() {
        return this.userDataProvider;
    }

    @MCChildElement(order=1)
    @Required
    public void setUserDataProvider(UserDataProvider userDataProvider) {
        this.userDataProvider = userDataProvider;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @MCChildElement(order=2)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public String getLocation() {
        return this.location;
    }

    @MCAttribute
    public void setLocation(String location) {
        this.location = location;
    }

    public String getPath() {
        return this.path;
    }

    @MCAttribute
    public void setPath(String path) {
        this.path = path;
    }

    public String getMessage() {
        return this.message;
    }

    @MCAttribute
    public void setMessage(String message) {
        this.message = message;
    }

    public AccountBlocker getAccountBlocker() {
        return this.accountBlocker;
    }

    @MCChildElement(order=3)
    public void setAccountBlocker(AccountBlocker accountBlocker) {
        this.accountBlocker = accountBlocker;
    }

    public boolean isExposeUserCredentialsToSession() {
        return this.exposeUserCredentialsToSession;
    }

    @MCAttribute
    public void setExposeUserCredentialsToSession(boolean exposeUserCredentialsToSession) {
        this.exposeUserCredentialsToSession = exposeUserCredentialsToSession;
    }

    public ClientList getClientList() {
        return this.clientList;
    }

    @MCChildElement(order=4)
    @Required
    public void setClientList(ClientList clientList) {
        this.clientList = clientList;
    }

    public TokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    @MCChildElement(order=5)
    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public HashSet<String> getSupportedAuthorizationGrants() {
        return this.supportedAuthorizationGrants;
    }

    public void setSupportedAuthorizationGrants(HashSet<String> supportedAuthorizationGrants) {
        this.supportedAuthorizationGrants = supportedAuthorizationGrants;
    }

    public OAuth2Processors getProcessors() {
        return this.processors;
    }

    public void setProcessors(OAuth2Processors processors) {
        this.processors = processors;
    }

    public SessionFinder getSessionFinder() {
        return this.sessionFinder;
    }

    public void setSessionFinder(SessionFinder sessionFinder) {
        this.sessionFinder = sessionFinder;
    }

    public JwtGenerator getJwtGenerator() {
        return this.jwtGenerator;
    }

    public String getIssuer() {
        return this.issuer;
    }

    @MCAttribute
    @Required
    public void setIssuer(String issuer) {
        this.issuer = issuer;
        if (issuer.endsWith("/")) {
            log.warn("In <oauth2authserver>, the 'issuer' attribute ends with a '/'. This should be avoided.");
        }
    }

    public ClaimList getClaimList() {
        return this.claimList;
    }

    @MCChildElement(order=6)
    @Required
    public void setClaimList(ClaimList claimList) {
        this.claimList = claimList;
    }

    public WellknownFile getWellknownFile() {
        return this.wellknownFile;
    }

    public void setWellknownFile(WellknownFile wellknownFile) {
        this.wellknownFile = wellknownFile;
    }

    public String getConsentFile() {
        return this.consentFile;
    }

    @MCAttribute
    public void setConsentFile(String consentFile) {
        this.consentFile = consentFile;
    }

    public ConsentPageFile getConsentPageFile() {
        return this.consentPageFile;
    }

    public void setConsentPageFile(ConsentPageFile consentPageFile) {
        this.consentPageFile = consentPageFile;
    }

    @Override
    public String getShortDescription() {
        return "Authorization server of the oauth2 authentication process.\n" + this.statistics.toString();
    }

    public void addSupportedAuthorizationGrants() {
        this.getSupportedAuthorizationGrants().add("code");
        this.getSupportedAuthorizationGrants().add("token");
        this.getSupportedAuthorizationGrants().add("id_token token");
    }

    public OAuth2Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(OAuth2Statistics statistics) {
        this.statistics = statistics;
    }

    public TokenGenerator getRefreshTokenGenerator() {
        return this.refreshTokenGenerator;
    }

    public void setRefreshTokenGenerator(TokenGenerator refreshTokenGenerator) {
        this.refreshTokenGenerator = refreshTokenGenerator;
    }

    public boolean isLoginViewDisabled() {
        return this.loginViewDisabled;
    }

    public void setLoginViewDisabled(boolean loginViewDisabled) {
        this.loginViewDisabled = loginViewDisabled;
    }

    public boolean isIssueNonSpecIdTokens() {
        return this.issueNonSpecIdTokens;
    }

    @MCAttribute
    public void setIssueNonSpecIdTokens(boolean issueNonSpecIdTokens) {
        this.issueNonSpecIdTokens = issueNonSpecIdTokens;
    }

    public boolean isIssueNonSpecRefreshTokens() {
        return this.issueNonSpecRefreshTokens;
    }

    @MCAttribute
    public void setIssueNonSpecRefreshTokens(boolean issueNonSpecRefreshTokens) {
        this.issueNonSpecRefreshTokens = issueNonSpecRefreshTokens;
    }

    public String computeBasePath() {
        Object rule = this.getRule();
        if (rule == null) {
            return "";
        }
        if (rule.getKey().getPath() == null || rule.getKey().isPathRegExp()) {
            return "";
        }
        return rule.getKey().getPath();
    }

    public String getBasePath() {
        return this.basePath;
    }
}

