/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.oauth2.ReusableJsonGenerator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.regex.Pattern;

public class OAuth2Util {
    public static String urlencode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urldecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void removeDuplicateSessionValues(HeaderField header) {
        String[] values;
        HashMap<String, String> uniqueValues = new HashMap<String, String>();
        for (String value : values = header.getValue().split(Pattern.quote(";"))) {
            String[] temp = value.split(Pattern.quote("="));
            if (uniqueValues.containsKey(temp[0])) continue;
            uniqueValues.put(temp[0].trim(), OAuth2Util.createSessionValue(temp));
        }
        header.setValue(OAuth2Util.buildSessionHeaderValue(uniqueValues));
    }

    private static String buildSessionHeaderValue(HashMap<String, String> uniqueValues) {
        StringBuilder builder = new StringBuilder();
        for (String key : uniqueValues.keySet()) {
            builder.append(";").append(key).append("=").append(uniqueValues.get(key));
        }
        builder.deleteCharAt(0);
        return builder.toString();
    }

    private static String createSessionValue(String[] temp) {
        Object param = "";
        for (int i = 1; i < temp.length; ++i) {
            param = (String)param + temp[i] + "=";
        }
        param = ((String)param).substring(0, ((String)param).length() - 1);
        return ((String)param).trim();
    }

    public static Message addSessionHeader(Message msg, HeaderField session) {
        msg.getHeader().add(session);
        return msg;
    }

    public static boolean isOpenIdScope(String scope) {
        if (scope != null && !scope.isEmpty() && scope.contains("openid")) {
            String[] split;
            for (String singleScope : split = scope.split(" ")) {
                if (!singleScope.equals("openid")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAbsoluteUri(String uri) {
        return uri.contains("://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response createParameterizedJsonErrorResponse(Exchange exc, ReusableJsonGenerator jsonGen, String ... params) throws IOException {
        String json;
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("The number of strings passed as params is not even");
        }
        ReusableJsonGenerator reusableJsonGenerator = jsonGen;
        synchronized (reusableJsonGenerator) {
            JsonGenerator gen = jsonGen.resetAndGet();
            gen.writeStartObject();
            for (int i = 0; i < params.length; i += 2) {
                gen.writeObjectField(params[i], (Object)params[i + 1]);
            }
            gen.writeEndObject();
            json = jsonGen.getJson();
        }
        return Response.badRequest().body(json).contentType("application/json;charset=utf-8").dontCache().build();
    }
}

