/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.authorizationservice;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;

@MCElement(name="google", topLevel=false)
public class GoogleAuthorizationService
extends AuthorizationService {
    @Override
    public void init() {
        if (!this.getClientId().endsWith(".apps.googleusercontent.com")) {
            this.setClientId(this.getClientId() + ".apps.googleusercontent.com");
        }
        if (this.scope == null) {
            this.scope = "openid%20email%20profile";
        }
    }

    @Override
    public String getIssuer() {
        return "https://accounts.google.com";
    }

    @Override
    public String getJwksEndpoint() throws Exception {
        return "https://www.googleapis.com/oauth2/v3/certs";
    }

    @Override
    public String getLoginURL(String securityToken, String callbackURL, String pathQuery) {
        return "https://accounts.google.com/o/oauth2/auth?client_id=" + this.getClientId() + "&response_type=code&scope=" + this.scope + "&redirect_uri=" + callbackURL + "&state=security_token%3D" + securityToken + "%26url%3D" + pathQuery;
    }

    @Override
    public String getTokenEndpoint() {
        return "https://www.googleapis.com/oauth2/v3/token";
    }

    @Override
    public String getRevocationEndpoint() {
        return "https://accounts.google.com/o/oauth2/revoke";
    }

    @Override
    public String getUserInfoEndpoint() {
        return "https://www.googleapis.com/oauth2/v3/userinfo";
    }

    @Override
    public String getSubject() {
        return "email";
    }
}

