/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.flows;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.ReusableJsonGenerator;
import com.predic8.membrane.core.interceptor.oauth2.flows.OAuth2Flow;
import java.io.IOException;

public class TokenFlow
extends OAuth2Flow {
    public TokenFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc, SessionManager.Session s) {
        super(authServer, exc, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome getResponse() throws IOException {
        Client client;
        SessionManager.Session session = this.session;
        synchronized (session) {
            client = this.authServer.getClientList().getClient(this.session.getUserAttributes().get("client_id"));
        }
        String grantTypes = client.getGrantTypes();
        if (!grantTypes.contains("implicit")) {
            this.exc.setResponse(OAuth2Util.createParameterizedJsonErrorResponse(this.exc, new ReusableJsonGenerator(), "error", "invalid_grant_type"));
            return Outcome.RETURN;
        }
        return this.respondWithTokenAndRedirect(this.exc, this.generateAccessToken(client), this.authServer.getTokenGenerator().getTokenType(), this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outcome respondWithTokenAndRedirect(Exchange exc, String token, String tokenType, SessionManager.Session s) {
        String scope;
        String redirectUrl;
        String state;
        SessionManager.Session session = s;
        synchronized (session) {
            state = s.getUserAttributes().get("state");
            redirectUrl = s.getUserAttributes().get("redirect_uri");
            scope = s.getUserAttributes().get("scope");
        }
        exc.setResponse(Response.redirect(redirectUrl + "?access_token=" + token + this.stateQuery(state) + "&token_type=" + tokenType + "&scope=" + scope, false).dontCache().body("").build());
        return Outcome.RETURN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateAccessToken(Client client) {
        SessionManager.Session session = this.session;
        synchronized (session) {
            String token = this.authServer.getTokenGenerator().getToken(this.session.getUserName(), client.getClientId(), client.getClientSecret());
            this.authServer.getSessionFinder().addSessionForToken(token, this.session);
            return token;
        }
    }
}

