/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.request.AuthWithSessionRequest;
import com.predic8.membrane.core.interceptor.oauth2.request.AuthWithoutSessionRequest;
import com.predic8.membrane.core.util.URLParamUtil;

public class AuthEndpointProcessor
extends EndpointProcessor {
    public AuthEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/oauth2/auth") && !this.authServer.isLoginViewDisabled();
    }

    @Override
    public Outcome process(Exchange exc) throws Exception {
        SessionManager.Session s = this.authServer.getSessionManager().getSession(exc);
        if (s != null) {
            exc.setResponse(new AuthWithSessionRequest(this.authServer, exc).validateRequest());
            return Outcome.RETURN;
        }
        exc.setResponse(new AuthWithoutSessionRequest(this.authServer, exc).validateRequest());
        return Outcome.RETURN;
    }

    private String getState(Exchange exc) throws Exception {
        return URLParamUtil.getParams(this.authServer.getRouter().getUriFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR).get("state");
    }
}

