/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.ClaimRenamer;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.flows.CodeFlow;
import com.predic8.membrane.core.interceptor.oauth2.flows.IdTokenTokenFlow;
import com.predic8.membrane.core.interceptor.oauth2.flows.TokenFlow;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.util.functionalInterfaces.Function;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;

public class EmptyEndpointProcessor
extends EndpointProcessor {
    public EmptyEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        SessionManager.Session s = this.authServer.getSessionManager().getSession(exc);
        return !(!exc.getRequestURI().equals(this.authServer.getBasePath() + "/") && !exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/?") || s == null || !s.isPreAuthorized() && !s.isAuthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome process(Exchange exc) throws Exception {
        SessionManager.Session s;
        SessionManager.Session session = s = this.authServer.getSessionManager().getOrCreateSession(exc);
        synchronized (session) {
            if (!OAuth2Util.isOpenIdScope(s.getUserAttributes().get("scope"))) {
                s.getUserAttributes().put("consent", "true");
            }
            if (!s.getUserAttributes().containsKey("consent")) {
                this.addConsentPageDataToSession(s);
                return this.redirectToConsentPage(exc);
            }
            if (s.getUserAttributes().get("consent").equals("true")) {
                s.authorize();
                return this.startOAuth2Flow(exc, s);
            }
        }
        exc.setResponse(OAuth2Util.createParameterizedJsonErrorResponse(exc, this.jsonGen, "error", "consent_required"));
        return Outcome.RETURN;
    }

    private Outcome startOAuth2Flow(Exchange exc, SessionManager.Session s) throws Exception {
        if (EmptyEndpointProcessor.getResponseType(s).equals("code")) {
            return new CodeFlow(this.authServer, exc, s).getResponse();
        }
        if (EmptyEndpointProcessor.getResponseType(s).equals("token")) {
            this.authServer.getStatistics().implicitFlow();
            return new TokenFlow(this.authServer, exc, s).getResponse();
        }
        if (EmptyEndpointProcessor.getResponseType(s).equals("id_token token")) {
            return new IdTokenTokenFlow(this.authServer, exc, s).getResponse();
        }
        exc.setResponse(OAuth2Util.createParameterizedJsonErrorResponse(exc, this.jsonGen, "error", "unsupported_response_type"));
        return Outcome.RETURN;
    }

    private void addConsentPageDataToSession(SessionManager.Session s) throws UnsupportedEncodingException {
        s.getUserAttributes().put("product_name", this.authServer.getConsentPageFile().getProductName());
        s.getUserAttributes().put("logo_url", this.authServer.getConsentPageFile().getLogoUrl());
        s.getUserAttributes().put("scope_descriptions", this.getScopeDescriptions(s.getUserAttributes().get("scope").split(" ")));
        s.getUserAttributes().put("claim_descriptions", this.getClaimDescriptions(this.processClaimsParameterToClaimsString(s.getUserAttributes().get("claims"))));
    }

    private String[] processClaimsParameterToClaimsString(String claimsParam) {
        ClaimsParameter cp = new ClaimsParameter(this.authServer.getClaimList().getSupportedClaims(), claimsParam);
        StringBuilder builder = new StringBuilder();
        HashSet<String> userinfo = cp.getUserinfoClaims();
        for (String claim : userinfo) {
            builder.append(" ").append(claim);
        }
        HashSet<String> idToken = cp.getIdTokenClaims();
        for (String claim : idToken) {
            builder.append(" ").append(claim);
        }
        return builder.toString().trim().split(" ");
    }

    private String getClaimDescriptions(String[] claims) throws UnsupportedEncodingException {
        return this.createDescription(claims, new Function<String, String>(){

            @Override
            public String call(String param) {
                return ClaimRenamer.convert(param);
            }
        }, new Function<String, String>(){

            @Override
            public String call(String claimParam) {
                return EmptyEndpointProcessor.this.authServer.getConsentPageFile().convertClaim(ClaimRenamer.convert(claimParam));
            }
        });
    }

    private String getScopeDescriptions(String[] scopes) throws UnsupportedEncodingException {
        return this.createDescription(scopes, new Function<String, String>(){

            @Override
            public String call(String param) {
                if (param.equals("openid")) {
                    return "";
                }
                return param;
            }
        }, new Function<String, String>(){

            @Override
            public String call(String scopeParam) {
                return EmptyEndpointProcessor.this.authServer.getConsentPageFile().convertScope(scopeParam);
            }
        });
    }

    private String createDescription(String[] params, Function<String, String> paramNameConverter, Function<String, String> paramValueConverter) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        HashSet<String> alreadyAddedParams = new HashSet<String>();
        for (String param : params) {
            String correctedParamName = paramNameConverter.call(param);
            if (correctedParamName.isEmpty() || alreadyAddedParams.contains(correctedParamName)) continue;
            alreadyAddedParams.add(correctedParamName);
            builder.append(" ").append(correctedParamName).append(" ").append(OAuth2Util.urlencode(paramValueConverter.call(param)));
        }
        return builder.toString().trim();
    }

    private Outcome redirectToConsentPage(Exchange exc) {
        exc.setResponse(Response.redirect((exc.getRequestURI().endsWith("/") ? exc.getRequestURI().substring(0, exc.getRequestURI().length() - 1) : exc.getRequestURI()) + "/login/consent", false).dontCache().bodyEmpty().build());
        return Outcome.RETURN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getResponseType(SessionManager.Session s) {
        SessionManager.Session session = s;
        synchronized (session) {
            return s.getUserAttributes().get("response_type");
        }
    }
}

