/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.processors;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.processors.EndpointProcessor;
import com.predic8.membrane.core.interceptor.oauth2.request.UserinfoRequest;

public class UserinfoEndpointProcessor
extends EndpointProcessor {
    public UserinfoEndpointProcessor(OAuth2AuthorizationServerInterceptor authServer) {
        super(authServer);
    }

    @Override
    public boolean isResponsible(Exchange exc) {
        return exc.getRequestURI().startsWith(this.authServer.getBasePath() + "/oauth2/userinfo");
    }

    @Override
    public Outcome process(Exchange exc) throws Exception {
        exc.setResponse(new UserinfoRequest(this.authServer, exc).validateRequest());
        if (exc.getResponse().getStatusCode() == 200) {
            this.authServer.getStatistics().accessTokenValid();
        } else {
            this.authServer.getStatistics().accessTokenInvalid();
        }
        return Outcome.RETURN;
    }
}

