/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.ParameterizedRequest;
import java.io.IOException;

public class AuthWithSessionRequest
extends ParameterizedRequest {
    public AuthWithSessionRequest(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        return new NoResponse();
    }

    @Override
    protected Response processWithParameters() throws Exception {
        if (this.getPrompt() != null) {
            return this.doOpenIDPrompt();
        }
        return this.redirectToEmptyEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response redirectToEmptyEndpoint() {
        SessionManager.Session session;
        SessionManager.Session session2 = session = this.authServer.getSessionManager().getOrCreateSession(this.exc);
        synchronized (session2) {
            session.getUserAttributes().put("state", this.getState());
        }
        return Response.redirect(this.authServer.getBasePath() + "/?" + this.getState(), false).build();
    }

    private Response doOpenIDPrompt() throws IOException {
        if (this.getPrompt().equals("login")) {
            return this.clearSessionAndRedirectToAuthEndpoint(this.exc);
        }
        if (this.getPrompt().equals("none") && !this.authServer.getSessionManager().getOrCreateSession(this.exc).isAuthorized()) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "login_required");
        }
        return new NoResponse();
    }

    @Override
    protected Response getResponse() throws Exception {
        return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "login_required");
    }

    private Response clearSessionAndRedirectToAuthEndpoint(Exchange exc) {
        this.authServer.getSessionManager().removeSession(exc);
        return AuthWithSessionRequest.redirectToOAuth2AuthEndpoint(exc);
    }

    private static Response redirectToOAuth2AuthEndpoint(Exchange exc) {
        return Response.redirect(exc.getRequestURI(), false).dontCache().bodyEmpty().build();
    }
}

