/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.ReusableJsonGenerator;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ParameterizedRequest {
    protected Exchange exc;
    protected OAuth2AuthorizationServerInterceptor authServer;
    protected Map<String, String> params;
    protected ReusableJsonGenerator jsonGen;

    protected abstract Response checkForMissingParameters() throws Exception;

    protected abstract Response processWithParameters() throws Exception;

    protected abstract Response getResponse() throws Exception;

    public Response validateRequest() throws Exception {
        Response resp = this.checkForMissingParameters();
        if (resp.getClass() != NoResponse.class) {
            return resp;
        }
        resp = this.processWithParameters();
        if (resp.getClass() != NoResponse.class) {
            return resp;
        }
        return this.getResponse();
    }

    public ParameterizedRequest(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        this.authServer = authServer;
        this.exc = exc;
        this.params = this.getValidParams(exc);
        this.jsonGen = new ReusableJsonGenerator();
    }

    private Map<String, String> getValidParams(Exchange exc) throws Exception {
        Map<String, String> params = URLParamUtil.getParams(this.authServer.getRouter().getUriFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        params.putAll(this.parseAuthentication(exc));
        this.removeEmptyParams(params);
        return params;
    }

    private Map<String, String> parseAuthentication(Exchange exc) {
        try {
            String authHeader = exc.getRequest().getHeader().getAuthorization();
            String[] creds = new String(Base64.getDecoder().decode(authHeader.split("Basic ")[1])).split(":");
            return Arrays.asList(new AbstractMap.SimpleEntry<String, String>("client_id", creds[0]), new AbstractMap.SimpleEntry<String, String>("client_secret", creds[1])).stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        }
        catch (Exception e2) {
            return new HashMap<String, String>();
        }
    }

    protected void removeEmptyParams(Map<String, String> params) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String paramName : params.keySet()) {
            if (!params.get(paramName).isEmpty()) continue;
            toRemove.add(paramName);
        }
        for (String paramName : toRemove) {
            params.remove(paramName);
        }
    }

    protected Response createParameterizedFormUrlencodedRedirect(Exchange exc, String state, String url) {
        if (state != null) {
            url = (String)url + "&state=" + state;
        }
        return Response.redirect((String)url, false).header("Content-Type", "application/x-www-form-urlencoded").bodyEmpty().dontCache().build();
    }

    protected Response buildWwwAuthenticateErrorResponse(Response.ResponseBuilder builder, String errorValue) {
        return builder.bodyEmpty().header("WWW-Authenticate", this.authServer.getTokenGenerator().getTokenType() + " error=\"" + errorValue + "\"").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addParams(SessionManager.Session session, Map<String, String> params) {
        Map<String, String> userAttributes;
        Map<String, String> map = userAttributes = session.getUserAttributes();
        synchronized (map) {
            userAttributes.putAll(params);
        }
    }

    protected Map<String, String> verifyUserThroughParams() {
        try {
            return this.authServer.getUserDataProvider().verify(this.params);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionManager.Session createSessionForAuthorizedUserWithParams() {
        SessionManager.Session session;
        SessionManager.Session session2 = session = this.authServer.getSessionManager().createSession(this.exc);
        synchronized (session2) {
            session.preAuthorize(this.getUsername(), this.params);
            session.authorize();
        }
        return session;
    }

    protected SessionManager.Session getSessionForAuthorizedUserWithParams() {
        return this.authServer.getSessionManager().getSession(this.exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionManager.Session createSessionForAuthorizedClientWithParams() {
        SessionManager.Session session;
        SessionManager.Session session2 = session = this.authServer.getSessionManager().createSession(this.exc);
        synchronized (session2) {
            session.preAuthorize(this.getClientId(), this.params);
            session.authorize();
        }
        return session;
    }

    protected boolean verifyClientThroughParams() {
        try {
            Client client = this.authServer.getClientList().getClient(this.getClientId());
            return client.verify(this.getClientId(), this.getClientSecret());
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String createTokenForVerifiedUserAndClient() {
        return this.authServer.getTokenGenerator().getToken(this.getUsername(), this.getClientId(), this.getClientSecret());
    }

    protected String createTokenForVerifiedClient() {
        return this.authServer.getTokenGenerator().getToken(this.getClientId(), this.getClientId(), this.getClientSecret());
    }

    public String getPrompt() {
        return this.params.get("prompt");
    }

    public String getClientId() {
        return this.params.get("client_id");
    }

    public String getRedirectUri() {
        return this.params.get("redirect_uri");
    }

    public String getResponseType() {
        return this.params.get("response_type");
    }

    public String getScope() {
        return this.params.get("scope");
    }

    public String getState() {
        return this.params.get("state");
    }

    public void setScope(String scope) {
        this.params.put("scope", scope);
    }

    public void setScopeInvalid(String invalidScopes) {
        this.params.put("scope_invalid", invalidScopes);
    }

    public String getCode() {
        return this.params.get("code");
    }

    public String getClientSecret() {
        return this.params.get("client_secret");
    }

    public String getClaims() {
        return this.params.get("claims");
    }

    public String getGrantType() {
        return this.params.get("grant_type");
    }

    public String getUsername() {
        return this.params.get("username");
    }

    public String getPassword() {
        return this.params.get("password");
    }

    public String getRefreshToken() {
        return this.params.get("refresh_token");
    }
}

