/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.tokengenerators;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.TokenGenerator;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

@MCElement(name="bearerToken")
public class BearerTokenGenerator
implements TokenGenerator {
    private SecureRandom random = new SecureRandom();
    private ConcurrentHashMap<String, User> tokenToUser = new ConcurrentHashMap();

    @Override
    public String getTokenType() {
        return "Bearer";
    }

    @Override
    public String getToken(String username, String clientId, String clientSecret) {
        String token = new BigInteger(130, this.random).toString(32);
        this.tokenToUser.put(token, new User(username, clientId, clientSecret));
        return token;
    }

    @Override
    public String getUsername(String token) throws NoSuchElementException {
        try {
            return this.tokenToUser.get(token).getUsername();
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    @Override
    public String getClientId(String token) throws NoSuchElementException {
        try {
            return this.tokenToUser.get(token).getClientId();
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    @Override
    public void invalidateToken(String token, String clientId, String clientSecret) throws NoSuchElementException {
        User user = this.tokenToUser.get(token);
        if (!clientId.equals(user.getClientId())) {
            throw new NoSuchElementException("ClientId doesn't match");
        }
        if (!clientSecret.equals(user.getClientSecret())) {
            throw new NoSuchElementException("ClientSecret doesn't match");
        }
        this.tokenToUser.remove(token);
    }

    public class User {
        private String username;
        private String clientId;
        private String clientSecret;

        public User(String username, String clientId, String clientSecret) {
            this.username = username;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }
    }
}

