/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.tokenvalidation;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.net.URISyntaxException;

@MCElement(name="tokenValidator")
public class OAuth2TokenValidatorInterceptor
extends AbstractInterceptor {
    private String endpoint;
    HttpClient client;

    @Override
    public void init(Router router) throws Exception {
        this.setFlow(Interceptor.Flow.Set.REQUEST);
        this.name = "Token validator";
        this.client = router.getHttpClientFactory().createClient(null);
    }

    @Override
    public String getShortDescription() {
        return "The token validator grants access to resources with valid access tokens.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        HttpClient httpClient = this.client;
        synchronized (httpClient) {
            if (this.callExchangeAndCheckFor200(this.buildAccessTokenValidationExchange(exc))) {
                return Outcome.CONTINUE;
            }
        }
        this.setResponseToBadRequest(exc);
        return Outcome.RETURN;
    }

    private boolean callExchangeAndCheckFor200(Exchange e) throws Exception {
        return this.client.call(e).getResponse().getStatusCode() == 200;
    }

    private void setResponseToBadRequest(Exchange exc) {
        new Response();
        exc.setResponse(Response.badRequest().build());
    }

    private Exchange buildAccessTokenValidationExchange(Exchange exc) throws URISyntaxException {
        return new Request.Builder().get(this.endpoint).header("Authorization", this.getAuthorizationHeaderValue(exc)).buildExchange();
    }

    private String getAuthorizationHeaderValue(Exchange exc) {
        return exc.getRequest().getHeader().getFirstValue("Authorization");
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @MCAttribute
    @Required
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

