/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.util.functionalInterfaces.Function;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@MCElement(name="oauth2PermissionChecker")
public class OAuth2PermissionCheckerInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OAuth2PermissionCheckerInterceptor.class);
    String expression;
    ValueSource valueSource;
    Function<Object, Boolean> valueChecker;

    public String getExpression() {
        return this.expression;
    }

    @MCAttribute
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    @MCChildElement(order=50)
    public void setValueSource(ValueSource valueSource) {
        this.valueSource = valueSource;
    }

    @Override
    public void init() throws Exception {
        this.valueChecker = this.createChecker(this.expression);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Object value = this.valueSource.evaluate(exc);
        if (!this.valueChecker.call(value).booleanValue()) {
            log.warn("OAuth2 permission check " + this.expression + " failed on value " + value);
            exc.setResponse(Response.forbidden().build());
            return Outcome.RETURN;
        }
        return super.handleRequest(exc);
    }

    private Function<Object, Boolean> createChecker(String expr) {
        SpelExpressionParser parser = new SpelExpressionParser();
        final Expression exp = parser.parseExpression(expr);
        return new Function<Object, Boolean>(){

            @Override
            public Boolean call(Object param) {
                if (!(param instanceof List)) {
                    return false;
                }
                ExpressionContext ec = new ExpressionContext((List)param);
                StandardEvaluationContext simpleContext = new StandardEvaluationContext((Object)ec);
                return (Boolean)exp.getValue((EvaluationContext)simpleContext, Boolean.class);
            }
        };
    }

    public static abstract class ValueSource {
        public abstract Object evaluate(Exchange var1);
    }

    public class ExpressionContext {
        private final List list;

        public ExpressionContext(List list) {
            this.list = list;
        }

        public boolean contains(Object value) {
            return this.list.contains(value);
        }
    }

    @MCElement(topLevel=false, name="userInfo")
    public static class UserInfoValueSource
    extends ValueSource {
        String field;

        public String getField() {
            return this.field;
        }

        @MCAttribute
        @Required
        public void setField(String field) {
            this.field = field;
        }

        @Override
        public Object evaluate(Exchange exc) {
            Object oauth2prop = exc.getProperty("oauth2");
            if (oauth2prop == null) {
                return null;
            }
            return ((OAuth2AnswerParameters)oauth2prop).getUserinfo().get("groups");
        }
    }
}

