/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptorWithSession;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.LogInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.jwt.Jwks;
import com.predic8.membrane.core.interceptor.jwt.JwtAuthInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Statistics;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import com.predic8.membrane.core.interceptor.oauth2client.CookieOriginialExchangeStore;
import com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore;
import com.predic8.membrane.core.interceptor.server.WebServerInterceptor;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.transport.ssl.PEMSupport;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="oauth2Resource2")
public class OAuth2Resource2Interceptor
extends AbstractInterceptorWithSession {
    public static final String OAUTH2_ANSWER = "oauth2Answer";
    public static final String OA2REDIRECT = "oa2redirect";
    public static final String OA2REDIRECT_PREFIX = "_redirect_for_oa2redirect_";
    private static Logger log = LoggerFactory.getLogger((String)OAuth2Resource2Interceptor.class.getName());
    private final Cache<String, Object> synchronizers = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    @GuardedBy(value="publicURLs")
    private List<String> publicURLs = new ArrayList<String>();
    private AuthorizationService auth;
    private OAuth2Statistics statistics;
    private Cache<String, Boolean> validTokens = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private int revalidateTokenAfter = -1;
    private WebServerInterceptor wsi;
    private URIFactory uriFactory;
    private boolean firstInitWhenDynamicAuthorizationService;
    private boolean initPublicURLsOnTheFly = false;
    private OriginalExchangeStore originalExchangeStore;
    private String callbackPath = "oauth2callback";
    private final ObjectMapper om = new ObjectMapper();
    private Key key;
    private X509Certificate certificate;
    private boolean skipUserInfo;
    private JwtAuthInterceptor jwtAuthInterceptor;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.originalExchangeStore == null) {
            this.originalExchangeStore = new CookieOriginialExchangeStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublicURL() {
        List<String> list = this.publicURLs;
        synchronized (list) {
            return String.join((CharSequence)" ", this.publicURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MCAttribute
    public void setPublicURL(String publicURL) {
        List<String> list = this.publicURLs;
        synchronized (list) {
            this.publicURLs.clear();
            for (String url : publicURL.split("[ \t]+")) {
                this.publicURLs.add(url);
            }
        }
    }

    public AuthorizationService getAuthService() {
        return this.auth;
    }

    @MCChildElement(order=10)
    @Required
    public void setAuthService(AuthorizationService auth) {
        this.auth = auth;
    }

    public int getRevalidateTokenAfter() {
        return this.revalidateTokenAfter;
    }

    @MCAttribute
    public void setRevalidateTokenAfter(int revalidateTokenAfter) {
        this.revalidateTokenAfter = revalidateTokenAfter;
    }

    public String getCallbackPath() {
        return this.callbackPath;
    }

    @MCAttribute
    public void setCallbackPath(String callbackPath) {
        this.callbackPath = callbackPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Router router) throws Exception {
        this.name = "OAuth 2 Client";
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE);
        super.init(router);
        this.auth.init(router);
        this.statistics = new OAuth2Statistics();
        this.uriFactory = router.getUriFactory();
        List<String> list = this.publicURLs;
        synchronized (list) {
            if (this.publicURLs.size() == 0) {
                this.initPublicURLsOnTheFly = true;
            } else {
                for (int i = 0; i < this.publicURLs.size(); ++i) {
                    this.publicURLs.set(i, this.normalizePublicURL(this.publicURLs.get(i)));
                }
            }
        }
        this.firstInitWhenDynamicAuthorizationService = this.getAuthService().supportsDynamicRegistration();
        if (!this.getAuthService().supportsDynamicRegistration()) {
            this.firstInitWhenDynamicAuthorizationService = false;
        }
        if (this.auth.isUseJWTForClientAuth()) {
            Object pemObject = PEMSupport.getInstance().parseKey(this.auth.getSslParser().getKey().getPrivate().get(router.getResolverMap(), router.getBaseLocation()));
            this.key = pemObject instanceof Key ? (Key)pemObject : ((KeyPair)pemObject).getPrivate();
            this.certificate = PEMSupport.getInstance().parseCertificate(this.auth.getSslParser().getKey().getCertificates().get(0).get(router.getResolverMap(), router.getBaseLocation()));
        }
        if (this.skipUserInfo) {
            this.jwtAuthInterceptor = new JwtAuthInterceptor();
            Jwks jwks = new Jwks();
            jwks.setJwks(new ArrayList<Jwks.Jwk>());
            jwks.setJwksUris(this.auth.getJwksEndpoint());
            this.jwtAuthInterceptor.setJwks(jwks);
            this.jwtAuthInterceptor.setExpectedAud("any!!");
            this.jwtAuthInterceptor.init(router);
        }
    }

    @Override
    public final Outcome handleRequestInternal(Exchange exc) throws Exception {
        return this.handleRequestInternal2(exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outcome handleRequestInternal2(Exchange exc) throws Exception {
        String auth;
        if (this.isFaviconRequest(exc)) {
            exc.setResponse(Response.badRequest().build());
            return Outcome.RETURN;
        }
        Session session = this.getSessionManager().getSession(exc);
        this.simplifyMultipleOAuth2Answers(session);
        if (this.isOAuth2RedirectRequest(exc)) {
            this.handleOriginalRequest(exc);
        }
        if (!(this.skipUserInfo || session != null && session.isVerified() || (auth = exc.getRequest().getHeader().getFirstValue("Authorization")) == null || !auth.substring(0, 7).equalsIgnoreCase("Bearer "))) {
            session = this.getSessionManager().getSession(exc);
            session.put("access_token", auth.substring(7));
            OAuth2AnswerParameters oauth2Answer = new OAuth2AnswerParameters();
            oauth2Answer.setAccessToken(auth.substring(7));
            oauth2Answer.setTokenType("Bearer");
            Map<String, Object> userinfo = this.revalidateToken(oauth2Answer);
            if (userinfo == null) {
                log.debug("userinfo is null, redirecting.");
                return this.respondWithRedirect(exc);
            }
            oauth2Answer.setUserinfo(userinfo);
            session.put(OAUTH2_ANSWER, oauth2Answer.serialize());
            this.processUserInfo(userinfo, session);
        }
        if (session == null) {
            log.debug("session is null, redirecting.");
            return this.respondWithRedirect(exc);
        }
        if (session.get(OAUTH2_ANSWER) != null && this.tokenNeedsRevalidation((String)session.get("access_token")) && this.revalidateToken(OAuth2AnswerParameters.deserialize((String)session.get(OAUTH2_ANSWER))) == null) {
            session.clear();
        }
        if (session.get(OAUTH2_ANSWER) != null) {
            exc.setProperty("oauth2", OAuth2AnswerParameters.deserialize((String)session.get(OAUTH2_ANSWER)));
        }
        if (this.refreshingOfAccessTokenIsNeeded(session)) {
            Object object = this.getTokenSynchronizer(session);
            synchronized (object) {
                try {
                    this.refreshAccessToken(session);
                    exc.setProperty("oauth2", OAuth2AnswerParameters.deserialize((String)session.get(OAUTH2_ANSWER)));
                }
                catch (Exception e) {
                    log.warn("Failed to refresh access token, clearing session and restarting OAuth2 flow.", (Throwable)e);
                    session.clearAuthentication();
                }
            }
        }
        if (session.isVerified()) {
            this.applyBackendAuthorization(exc, session);
            this.statistics.successfulRequest();
            return Outcome.CONTINUE;
        }
        if (this.handleRequest(exc, this.getPublicURL(exc), session)) {
            if (exc.getResponse() == null && exc.getRequest() != null && session.isVerified() && session.get().containsKey(OAUTH2_ANSWER)) {
                exc.setProperty("oauth2", OAuth2AnswerParameters.deserialize((String)session.get(OAUTH2_ANSWER)));
                return Outcome.CONTINUE;
            }
            if (exc.getResponse().getStatusCode() >= 400) {
                session.clear();
            }
            return Outcome.RETURN;
        }
        log.debug("session present, but not verified, redirecting.");
        return this.respondWithRedirect(exc);
    }

    private void simplifyMultipleOAuth2Answers(Session session) {
        if (session == null) {
            return;
        }
        String answer = (String)session.get(OAUTH2_ANSWER);
        if (answer == null) {
            return;
        }
        int indexOfTopLevelComma = this.getIndexOfTopLevelComma(answer);
        if (indexOfTopLevelComma == -1) {
            return;
        }
        answer = answer.substring(0, indexOfTopLevelComma);
        session.put(OAUTH2_ANSWER, answer);
    }

    private int getIndexOfTopLevelComma(String answer) {
        int curlyBraceLevel = 0;
        boolean inString = false;
        boolean escapeNext = false;
        block10: for (int i = 0; i < answer.length(); ++i) {
            if (escapeNext) {
                escapeNext = false;
                continue;
            }
            char c = answer.charAt(i);
            if (inString) {
                switch (c) {
                    case '\"': {
                        inString = false;
                        break;
                    }
                    case '\\': {
                        escapeNext = true;
                    }
                }
                continue;
            }
            switch (c) {
                case '{': {
                    ++curlyBraceLevel;
                    continue block10;
                }
                case '}': {
                    --curlyBraceLevel;
                    continue block10;
                }
                case ',': {
                    if (curlyBraceLevel != 0) continue block10;
                    return i;
                }
                case '\"': {
                    inString = true;
                }
            }
        }
        return -1;
    }

    private Object getTokenSynchronizer(Session session) {
        OAuth2AnswerParameters oauth2Params = null;
        try {
            oauth2Params = OAuth2AnswerParameters.deserialize((String)session.get(OAUTH2_ANSWER));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String rt = oauth2Params.getRefreshToken();
        if (rt == null) {
            return new Object();
        }
        try {
            return this.synchronizers.get((Object)rt, () -> new Object());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleOriginalRequest(Exchange exc) throws Exception {
        Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        String oa2redirect = params.get(OA2REDIRECT);
        Session session = this.getSessionManager().getSession(exc);
        AbstractExchange originalExchange = ((AbstractExchangeSnapshot)new ObjectMapper().readValue(session.get(this.oa2redictKeyNameInSession(oa2redirect)).toString(), AbstractExchangeSnapshot.class)).toAbstractExchange();
        session.remove(this.oa2redictKeyNameInSession(oa2redirect));
        this.doOriginalRequest(exc, originalExchange);
    }

    private boolean isOAuth2RedirectRequest(Exchange exc) {
        return exc.getOriginalRequestUri().contains(OA2REDIRECT);
    }

    private void refreshAccessToken(Session session) throws Exception {
        if (!this.refreshingOfAccessTokenIsNeeded(session)) {
            return;
        }
        OAuth2AnswerParameters oauth2Params = OAuth2AnswerParameters.deserialize((String)session.get(OAUTH2_ANSWER));
        Exchange refreshTokenExchange = this.applyAuth(this.auth, new Request.Builder().post(this.auth.getTokenEndpoint()).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").header("User-Agent", Constants.USERAGENT), "grant_type=refresh_token&refresh_token=" + oauth2Params.getRefreshToken()).buildExchange();
        Response refreshTokenResponse = this.auth.doRequest(refreshTokenExchange);
        if (!refreshTokenResponse.isOk()) {
            refreshTokenResponse.getBody().read();
            throw new RuntimeException("Statuscode from authorization server for refresh token request: " + refreshTokenResponse.getStatusCode());
        }
        if (!this.isJson(refreshTokenResponse)) {
            throw new RuntimeException("Refresh Token response is no JSON.");
        }
        Map json = (Map)this.om.readValue(refreshTokenResponse.getBodyAsStreamDecoded(), Map.class);
        if (json.get("access_token") == null || json.get("refresh_token") == null) {
            refreshTokenResponse.getBody().read();
            throw new RuntimeException("Statuscode was ok but no access_token and refresh_token was received: " + refreshTokenResponse.getStatusCode());
        }
        oauth2Params.setAccessToken((String)json.get("access_token"));
        oauth2Params.setRefreshToken((String)json.get("refresh_token"));
        oauth2Params.setExpiration(this.numberToString(json.get("expires_in")));
        LocalDateTime now = LocalDateTime.now();
        oauth2Params.setReceivedAt(now.withSecond(now.getSecond() / 30 * 30).withNano(0));
        if (json.containsKey("id_token")) {
            if (this.idTokenIsValid((String)json.get("id_token"))) {
                oauth2Params.setIdToken((String)json.get("id_token"));
            } else {
                oauth2Params.setIdToken("INVALID");
            }
        }
        session.put(OAUTH2_ANSWER, oauth2Params.serialize());
    }

    private Request.Builder applyAuth(AuthorizationService auth, Request.Builder requestBuilder, String body) {
        String clientSecret;
        if (auth.isUseJWTForClientAuth()) {
            body = (String)body + "&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_assertion=" + this.createClientToken(auth);
        }
        if ((clientSecret = auth.getClientSecret()) != null) {
            requestBuilder.header("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(auth.getClientId() + ":" + clientSecret).getBytes()))).body((String)body);
        } else {
            requestBuilder.body((String)body + "&client_id" + auth.getClientId());
        }
        return requestBuilder;
    }

    private String createClientToken(AuthorizationService auth) {
        try {
            String jwtSub = auth.getClientId();
            String jwtAud = auth.getTokenEndpoint();
            JwtClaims jwtClaims = new JwtClaims();
            jwtClaims.setSubject(jwtSub);
            jwtClaims.setAudience(jwtAud);
            jwtClaims.setIssuer(jwtClaims.getSubject());
            jwtClaims.setJwtId(UUID.randomUUID().toString());
            jwtClaims.setIssuedAtToNow();
            NumericDate expiration = NumericDate.now();
            expiration.addSeconds(300L);
            jwtClaims.setExpirationTime(expiration);
            jwtClaims.setNotBeforeMinutesInThePast(2.0f);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(jwtClaims.toJson());
            jws.setKey(this.key);
            jws.setX509CertSha1ThumbprintHeaderValue(this.certificate);
            jws.setAlgorithmHeaderValue("RS256");
            jws.setHeader("typ", "JWT");
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedClaimException e) {
            throw new RuntimeException(e);
        }
    }

    private String numberToString(Object number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return ((Integer)number).toString();
        }
        if (number instanceof Long) {
            return ((Long)number).toString();
        }
        if (number instanceof Double) {
            return ((Double)number).toString();
        }
        if (number instanceof String) {
            return (String)number;
        }
        log.warn("Unhandled number type " + number.getClass().getName());
        return null;
    }

    private boolean isJson(Response g) throws ParseException {
        String contentType = g.getHeader().getFirstValue("Content-Type");
        if (contentType == null) {
            return false;
        }
        return g.getHeader().getContentTypeObject().match("application/json");
    }

    private boolean refreshingOfAccessTokenIsNeeded(Session session) throws IOException {
        if (session.get(OAUTH2_ANSWER) == null) {
            return false;
        }
        OAuth2AnswerParameters oauth2Params = OAuth2AnswerParameters.deserialize((String)session.get(OAUTH2_ANSWER));
        if (oauth2Params.getRefreshToken() == null || oauth2Params.getRefreshToken().isEmpty() || oauth2Params.getExpiration() == null || oauth2Params.getExpiration().isEmpty()) {
            return false;
        }
        return LocalDateTime.now().isAfter(oauth2Params.getReceivedAt().plusSeconds(Long.parseLong(oauth2Params.getExpiration())).minusSeconds(5L));
    }

    private Map<String, Object> revalidateToken(OAuth2AnswerParameters params) throws Exception {
        Exchange e2 = new Request.Builder().get(this.auth.getUserInfoEndpoint()).header("Authorization", params.getTokenType() + " " + params.getAccessToken()).header("User-Agent", Constants.USERAGENT).header("Accept", "application/json").buildExchange();
        Response response2 = this.auth.doRequest(e2);
        if (response2.getStatusCode() != 200) {
            this.statistics.accessTokenInvalid();
            return null;
        }
        this.statistics.accessTokenValid();
        if (!this.isJson(response2)) {
            throw new RuntimeException("Response is no JSON.");
        }
        return (Map)this.om.readValue(response2.getBodyAsStreamDecoded(), Map.class);
    }

    private boolean tokenNeedsRevalidation(String token) {
        if (this.revalidateTokenAfter < 0) {
            return false;
        }
        return this.validTokens.getIfPresent((Object)token) == null;
    }

    @Override
    protected Outcome handleResponseInternal(Exchange exc) throws Exception {
        return Outcome.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPublicURL(Exchange exc) throws Exception {
        String xForwardedProto = exc.getRequest().getHeader().getFirstValue("X-Forwarded-Proto");
        boolean isHTTPS = xForwardedProto != null ? "https".equals(xForwardedProto) : exc.getRule().getSslInboundContext() != null;
        Object publicURL = (isHTTPS ? "https://" : "http://") + exc.getOriginalHostHeader();
        RuleKey key = exc.getRule().getKey();
        if (!key.isPathRegExp() && key.getPath() != null) {
            publicURL = (String)publicURL + key.getPath();
        }
        publicURL = this.normalizePublicURL((String)publicURL);
        List<String> list = this.publicURLs;
        synchronized (list) {
            if (this.publicURLs.contains(publicURL)) {
                return publicURL;
            }
            if (!this.initPublicURLsOnTheFly) {
                return this.publicURLs.get(0);
            }
        }
        String newURL = null;
        if (this.initPublicURLsOnTheFly) {
            newURL = this.addPublicURL((String)publicURL);
        }
        if (this.firstInitWhenDynamicAuthorizationService && newURL != null) {
            this.getAuthService().dynamicRegistration(this.getPublicURLs().stream().map(url -> url + this.callbackPath).collect(Collectors.toList()));
        }
        return publicURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addPublicURL(String publicURL) {
        List<String> list = this.publicURLs;
        synchronized (list) {
            if (this.publicURLs.contains(publicURL)) {
                return null;
            }
            this.publicURLs.add(publicURL);
        }
        return publicURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPublicURLs() {
        List<String> list = this.publicURLs;
        synchronized (list) {
            return new ArrayList<String>(this.publicURLs);
        }
    }

    private String normalizePublicURL(String url) {
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    private boolean isFaviconRequest(Exchange exc) {
        return exc.getRequestURI().startsWith("/favicon.ico");
    }

    private void applyBackendAuthorization(Exchange exc, Session s) {
        Header h = exc.getRequest().getHeader();
        for (Map.Entry<String, Object> e : s.get().entrySet()) {
            if (!e.getKey().startsWith("header")) continue;
            String headerName = e.getKey().substring(6);
            h.removeFields(headerName);
            h.add(headerName, e.getValue().toString());
        }
    }

    private Outcome respondWithRedirect(Exchange exc) throws Exception {
        Object state = new BigInteger(130, new SecureRandom()).toString(32);
        exc.setResponse(Response.redirect(this.auth.getLoginURL((String)state, this.getPublicURL(exc) + this.callbackPath, exc.getRequestURI()), false).build());
        this.readBodyFromStreamIntoMemory(exc);
        Session session = this.getSessionManager().getSession(exc);
        this.originalExchangeStore.store(exc, session, (String)state, exc);
        if (session.get().containsKey("state")) {
            state = session.get("state") + "," + (String)state;
        }
        session.put("state", state);
        return Outcome.RETURN;
    }

    private String oa2redictKeyNameInSession(String oa2redirect) {
        return OA2REDIRECT_PREFIX + oa2redirect;
    }

    private void readBodyFromStreamIntoMemory(Exchange exc) {
        exc.getRequest().getBodyAsStringDecoded();
    }

    public boolean handleRequest(Exchange exc, String publicURL, Session session) throws Exception {
        String path = this.uriFactory.create(exc.getDestinations().get(0)).getPath();
        if (path == null) {
            return false;
        }
        if (path.endsWith("/" + this.callbackPath)) {
            try {
                Response response;
                String code;
                Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
                String state2 = params.get("state");
                String stateFromUri = this.getSecurityTokenFromState(state2);
                if (!this.csrfTokenMatches(session, stateFromUri)) {
                    throw new RuntimeException("CSRF token mismatch.");
                }
                session.put("state", stateFromUri);
                AbstractExchangeSnapshot originalRequest = this.originalExchangeStore.reconstruct(exc, session, stateFromUri);
                String url = originalRequest.getRequest().getUri();
                if (url == null) {
                    url = "/";
                }
                this.originalExchangeStore.remove(exc, session, stateFromUri);
                if (log.isDebugEnabled()) {
                    log.debug("CSRF token match.");
                }
                if ((code = params.get("code")) == null) {
                    throw new RuntimeException("No code received.");
                }
                Exchange e = this.applyAuth(this.auth, new Request.Builder().post(this.auth.getTokenEndpoint()).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").header("User-Agent", Constants.USERAGENT), "code=" + code + "&redirect_uri=" + publicURL + this.callbackPath + "&grant_type=authorization_code").buildExchange();
                LogInterceptor logi = null;
                if (log.isDebugEnabled()) {
                    logi = new LogInterceptor();
                    logi.setHeaderOnly(false);
                    logi.handleRequest(e);
                }
                if ((response = this.auth.doRequest(e)).getStatusCode() != 200) {
                    response.getBody().read();
                    throw new RuntimeException("Authorization server returned " + response.getStatusCode() + ".");
                }
                if (log.isDebugEnabled()) {
                    logi.handleResponse(e);
                }
                if (!this.isJson(response)) {
                    throw new RuntimeException("Token response is no JSON.");
                }
                Map json = (Map)this.om.readValue(response.getBodyAsStreamDecoded(), Map.class);
                if (!json.containsKey("access_token")) {
                    throw new RuntimeException("No access_token received.");
                }
                String token = (String)json.get("access_token");
                OAuth2AnswerParameters oauth2Answer = new OAuth2AnswerParameters();
                session.put("access_token", token);
                oauth2Answer.setAccessToken(token);
                oauth2Answer.setTokenType((String)json.get("token_type"));
                oauth2Answer.setExpiration(this.numberToString(json.get("expires_in")));
                oauth2Answer.setRefreshToken((String)json.get("refresh_token"));
                LocalDateTime now = LocalDateTime.now();
                oauth2Answer.setReceivedAt(now.withSecond(now.getSecond() / 30 * 30).withNano(0));
                if (json.containsKey("id_token")) {
                    if (this.idTokenIsValid((String)json.get("id_token"))) {
                        oauth2Answer.setIdToken((String)json.get("id_token"));
                    } else {
                        oauth2Answer.setIdToken("INVALID");
                    }
                }
                this.validTokens.put((Object)token, (Object)true);
                if (!this.skipUserInfo) {
                    Exchange e2 = new Request.Builder().get(this.auth.getUserInfoEndpoint()).header("Authorization", json.get("token_type") + " " + token).header("User-Agent", Constants.USERAGENT).header("Accept", "application/json").buildExchange();
                    if (log.isDebugEnabled()) {
                        logi.setHeaderOnly(false);
                        logi.handleRequest(e2);
                    }
                    Response response2 = this.auth.doRequest(e2);
                    if (log.isDebugEnabled()) {
                        logi.handleResponse(e2);
                    }
                    if (response2.getStatusCode() != 200) {
                        this.statistics.accessTokenInvalid();
                        throw new RuntimeException("User data could not be retrieved.");
                    }
                    this.statistics.accessTokenValid();
                    if (!this.isJson(response2)) {
                        throw new RuntimeException("Userinfo response is no JSON.");
                    }
                    Map json2 = (Map)this.om.readValue(response2.getBodyAsStreamDecoded(), Map.class);
                    oauth2Answer.setUserinfo(json2);
                    session.put(OAUTH2_ANSWER, oauth2Answer.serialize());
                    this.processUserInfo(json2, session);
                } else {
                    session.put(OAUTH2_ANSWER, oauth2Answer.serialize());
                    if (this.jwtAuthInterceptor.handleJwt(exc, token) != Outcome.CONTINUE) {
                        throw new RuntimeException("Access token is not a JWT.");
                    }
                    this.processUserInfo((Map)exc.getProperty("jwt"), session);
                }
                this.doRedirect(exc, originalRequest);
                this.originalExchangeStore.postProcess(exc);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                exc.setResponse(Response.badRequest().body(e.getMessage()).build());
                this.originalExchangeStore.postProcess(exc);
                return true;
            }
        }
        return false;
    }

    private String getSecurityTokenFromState(String state2) {
        if (state2 == null) {
            throw new RuntimeException("No CSRF token.");
        }
        Map<String, String> param = URLParamUtil.parseQueryString(state2, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        if (param == null || !param.containsKey("security_token")) {
            throw new RuntimeException("No CSRF token.");
        }
        return param.get("security_token");
    }

    private boolean csrfTokenMatches(Session session, String state2) {
        Optional sessionRaw = Optional.ofNullable(session.get("state"));
        if (!sessionRaw.isPresent()) {
            return false;
        }
        return Arrays.asList(sessionRaw.get().toString().split(",")).stream().filter(s -> s.equals(state2)).count() == 1L;
    }

    private void doRedirect(Exchange exc, AbstractExchangeSnapshot originalRequest) throws JsonProcessingException {
        if (originalRequest.getRequest().getMethod().equals("GET")) {
            exc.setResponse(Response.redirect(originalRequest.getOriginalRequestUri(), false).build());
        } else {
            String oa2redirect = new BigInteger(130, new SecureRandom()).toString(32);
            Session session = this.getSessionManager().getSession(exc);
            session.put(this.oa2redictKeyNameInSession(oa2redirect), new ObjectMapper().writeValueAsString((Object)originalRequest));
            String delimiter = originalRequest.getOriginalRequestUri().contains("?") ? "&" : "?";
            exc.setResponse(Response.redirect(originalRequest.getOriginalRequestUri() + delimiter + "oa2redirect=" + oa2redirect, false).build());
        }
    }

    private void doOriginalRequest(Exchange exc, AbstractExchange originalRequest) throws Exception {
        originalRequest.getRequest().getHeader().add("Cookie", exc.getRequest().getHeader().getFirstValue("Cookie"));
        exc.setRequest(originalRequest.getRequest());
        exc.getDestinations().clear();
        String xForwardedProto = originalRequest.getRequest().getHeader().getFirstValue("X-Forwarded-Proto");
        String xForwardedHost = originalRequest.getRequest().getHeader().getFirstValue("X-Forwarded-Host");
        String originalRequestUri = originalRequest.getOriginalRequestUri();
        exc.getDestinations().add(xForwardedProto + "://" + xForwardedHost + originalRequestUri);
        exc.setOriginalRequestUri(originalRequestUri);
        exc.setOriginalHostHeader(xForwardedHost);
    }

    private void processUserInfo(Map<String, Object> userInfo, Session session) {
        if (!userInfo.containsKey(this.auth.getSubject())) {
            throw new RuntimeException("User object does not contain " + this.auth.getSubject() + " key.");
        }
        Map<String, Object> userAttributes = session.get();
        String userIdPropertyFixed = this.auth.getSubject().substring(0, 1).toUpperCase() + this.auth.getSubject().substring(1);
        String username = (String)userInfo.get(this.auth.getSubject());
        userAttributes.put("headerX-Authenticated-" + userIdPropertyFixed, username);
        session.authorize(username);
    }

    private boolean idTokenIsValid(String idToken) throws Exception {
        try {
            JwtGenerator.getClaimsFromSignedIdToken(idToken, this.getAuthService().getIssuer(), this.getAuthService().getClientId(), this.getAuthService().getJwksEndpoint(), this.auth);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getShortDescription() {
        return "Client of the oauth2 authentication process.\n" + this.statistics.toString();
    }

    public OriginalExchangeStore getOriginalExchangeStore() {
        return this.originalExchangeStore;
    }

    @MCChildElement(order=20, allowForeign=true)
    public void setOriginalExchangeStore(OriginalExchangeStore originalExchangeStore) {
        this.originalExchangeStore = originalExchangeStore;
    }

    public boolean isSkipUserInfo() {
        return this.skipUserInfo;
    }

    @MCAttribute
    public void setSkipUserInfo(boolean skipUserInfo) {
        this.skipUserInfo = skipUserInfo;
    }
}

