/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.util.RedisConnector;
import java.io.IOException;
import redis.clients.jedis.Jedis;

@MCElement(name="redisOriginalExchangeStore")
public class RedisOriginalExchangeStore
extends OriginalExchangeStore {
    private int maxBodySize = 100000;
    private String prefix;
    private ObjectMapper objMapper = new ObjectMapper();
    private RedisConnector connector;

    private String originalRequestKeyNameInSession(String state) {
        return this.prefix != null ? this.prefix + state : state;
    }

    @Override
    public void store(Exchange exchange, Session session, String state, Exchange exchangeToStore) throws IOException {
        try (Jedis jedis = this.connector.getJedisWithDb();){
            jedis.setex(this.originalRequestKeyNameInSession(state), 3600L, this.objMapper.writeValueAsString((Object)this.getTrimmedAbstractExchangeSnapshot(exchangeToStore, this.maxBodySize)));
        }
    }

    @Override
    public AbstractExchangeSnapshot reconstruct(Exchange exchange, Session session, String state) {
        AbstractExchangeSnapshot abstractExchangeSnapshot;
        block8: {
            Jedis jedis = this.connector.getJedisWithDb();
            try {
                abstractExchangeSnapshot = (AbstractExchangeSnapshot)this.objMapper.readValue(jedis.get(this.originalRequestKeyNameInSession(state)), AbstractExchangeSnapshot.class);
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            jedis.close();
        }
        return abstractExchangeSnapshot;
    }

    @Override
    public void remove(Exchange exchange, Session session, String state) {
        try (Jedis jedis = this.connector.getJedisWithDb();){
            jedis.del(this.originalRequestKeyNameInSession(state));
        }
    }

    @Override
    public void postProcess(Exchange exchange) {
    }

    public int getMaxBodySize() {
        return this.maxBodySize;
    }

    @MCAttribute
    public void setMaxBodySize(int maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public RedisConnector getConnector() {
        return this.connector;
    }

    @MCAttribute
    public void setConnector(RedisConnector connector) {
        this.connector = connector;
    }
}

