/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.snapshots.AbstractExchangeSnapshot;
import com.predic8.membrane.core.interceptor.oauth2client.OriginalExchangeStore;
import com.predic8.membrane.core.interceptor.session.Session;
import java.io.IOException;

@MCElement(name="sessionOriginalExchangeStore")
public class SessionOriginalExchangeStore
extends OriginalExchangeStore {
    public static final String ORIGINAL_REQUEST_PREFIX = "_original_request_for_state_";
    private int maxBodySize = 100000;

    private String originalRequestKeyNameInSession(String state) {
        return ORIGINAL_REQUEST_PREFIX + state;
    }

    @Override
    public void store(Exchange exchange, Session session, String state, Exchange exchangeToStore) throws IOException {
        try {
            session.put(this.originalRequestKeyNameInSession(state), new ObjectMapper().writeValueAsString((Object)this.getTrimmedAbstractExchangeSnapshot(exchangeToStore, this.maxBodySize)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AbstractExchangeSnapshot reconstruct(Exchange exchange, Session session, String state) {
        try {
            return (AbstractExchangeSnapshot)new ObjectMapper().readValue(session.get(this.originalRequestKeyNameInSession(state)).toString(), AbstractExchangeSnapshot.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(Exchange exc, Session session, String state) {
        session.remove(this.originalRequestKeyNameInSession(state));
    }

    @Override
    public void postProcess(Exchange exc) {
    }

    public int getMaxBodySize() {
        return this.maxBodySize;
    }

    @MCAttribute
    public void setMaxBodySize(int maxBodySize) {
        this.maxBodySize = maxBodySize;
    }
}

