/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ratelimit;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.ratelimit.LazyRateLimit;
import com.predic8.membrane.core.interceptor.ratelimit.RateLimitStrategy;
import com.predic8.membrane.core.util.ErrorUtil;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormat;

@MCElement(name="rateLimiter")
public class RateLimitInterceptor
extends AbstractInterceptor {
    public RateLimitStrategy rateLimitStrategy;
    protected static DateTimeFormatter dtFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss aa");
    protected DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZoneUTC().withLocale(Locale.US);

    public RateLimitInterceptor() {
        this(Duration.standardHours((long)1L), 1000);
    }

    public RateLimitInterceptor(Duration requestLimitDuration, int requestLimit) {
        this.rateLimitStrategy = new LazyRateLimit(requestLimitDuration, requestLimit);
        this.name = "RateLimiter";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        String addr = exc.getRemoteAddrIp();
        if (this.rateLimitStrategy.isRequestLimitReached(addr)) {
            this.setResponseToServiceUnavailable(exc);
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    public void setResponseToServiceUnavailable(Exchange exc) {
        ErrorUtil.createAndSetErrorResponse(exc, 429, this.createErrorMessage(exc));
        exc.getResponse().setHeader(this.createHeaderFields(exc));
    }

    private Header createHeaderFields(Exchange exc) {
        Header hd = new Header();
        hd.add("Date", this.dateFormatter.print((ReadableInstant)DateTime.now()));
        hd.add("X-LimitDuration", this.rateLimitStrategy.getLimitDurationPeriod());
        hd.add("X-LimitRequests", Integer.toString(this.rateLimitStrategy.requestLimit));
        hd.add("X-LimitReset", this.rateLimitStrategy.getLimitReset(exc.getRemoteAddrIp()));
        return hd;
    }

    private String createErrorMessage(Exchange exc) {
        return exc.getRemoteAddrIp() + " exceeded the rate limit of " + this.rateLimitStrategy.requestLimit + " requests per " + PeriodFormat.getDefault().print((ReadablePeriod)this.rateLimitStrategy.requestLimitDuration.toPeriod()) + ". The next request can be made at " + dtFormatter.print((ReadableInstant)this.rateLimitStrategy.getServiceAvailableAgainTime(exc.getRemoteAddrIp()));
    }

    public int getRequestLimit() {
        return this.rateLimitStrategy.requestLimit;
    }

    @MCAttribute
    public void setRequestLimit(int rl) {
        this.rateLimitStrategy.setRequestLimit(rl);
    }

    public String getRequestLimitDuration() {
        return this.rateLimitStrategy.requestLimitDuration.toString();
    }

    @MCAttribute
    public void setRequestLimitDuration(String rld) {
        this.setRequestLimitDuration(Duration.parse((String)rld));
    }

    public void setRequestLimitDuration(Duration rld) {
        this.rateLimitStrategy.setRequestLimitDuration(rld);
    }

    @Override
    public String getShortDescription() {
        return "Limits incoming requests. It limits to " + this.rateLimitStrategy.getRequestLimit() + " requests every " + PeriodFormat.getDefault().print((ReadablePeriod)this.rateLimitStrategy.getRequestLimitDuration().toPeriod()) + ".";
    }
}

