/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ratelimit;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

public abstract class RateLimitStrategy {
    protected Duration requestLimitDuration;
    protected int requestLimit;

    public Duration getRequestLimitDuration() {
        return this.requestLimitDuration;
    }

    public void setRequestLimitDuration(Duration requestLimitDuration) {
        this.requestLimitDuration = requestLimitDuration;
        this.updateAfterConfigChange();
    }

    public int getRequestLimit() {
        return this.requestLimit;
    }

    public void setRequestLimit(int requestLimit) {
        this.requestLimit = requestLimit;
        this.updateAfterConfigChange();
    }

    public String getLimitDurationPeriod() {
        return PeriodFormat.getDefault().print((ReadablePeriod)this.requestLimitDuration.toPeriod());
    }

    public String getLimitReset(String ip) {
        return Long.toString(this.getServiceAvailableAgainTime(ip).getMillis());
    }

    public abstract boolean isRequestLimitReached(String var1);

    public abstract DateTime getServiceAvailableAgainTime(String var1);

    public abstract void updateAfterConfigChange();
}

