/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rest;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.xml.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.rest.REST2SOAPInterceptor;
import com.predic8.membrane.core.interceptor.xslt.XSLTTransformer;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SOAPRESTHelper
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)REST2SOAPInterceptor.class.getName());
    private final ConcurrentHashMap<String, XSLTTransformer> xsltTransformers = new ConcurrentHashMap();

    SOAPRESTHelper() {
    }

    protected XSLTTransformer getTransformer(String ss) throws Exception {
        int concurrency;
        XSLTTransformer t2;
        String key = ss == null ? "null" : ss;
        XSLTTransformer t = this.xsltTransformers.get(key);
        if (t == null && (t2 = this.xsltTransformers.putIfAbsent(key, t = new XSLTTransformer(ss, this.router, concurrency = 2 * Runtime.getRuntime().availableProcessors()))) != null) {
            return t2;
        }
        return t;
    }

    protected StreamSource getRequestXMLSource(Exchange exc) throws Exception {
        Request req = new Request(exc.getRequest());
        String res = req.toXml();
        log.debug("http-xml: " + res);
        return new StreamSource(new StringReader(res));
    }

    protected StreamSource getExchangeXMLSource(Exchange exc) throws Exception {
        com.predic8.membrane.core.http.xml.Exchange xmlExc = new com.predic8.membrane.core.http.xml.Exchange(exc);
        String res = xmlExc.toXml();
        log.debug("http-xml: " + res);
        return new StreamSource(new StringReader(res));
    }

    protected void transformAndReplaceBody(Message msg, String ss, Source src, Map<String, String> properties) throws Exception {
        byte[] soapEnv = this.getTransformer(ss).transform(src, properties);
        if (log.isDebugEnabled()) {
            log.debug("soap-env: " + new String(soapEnv, Constants.UTF_8_CHARSET));
        }
        msg.setBodyContent(soapEnv);
    }
}

