/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rewrite;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="reverseProxying")
public class ReverseProxyingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyingInterceptor.class);

    public ReverseProxyingInterceptor() {
        this.name = "Reverse Proxy";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest() == null) {
            return Outcome.CONTINUE;
        }
        String destination = exc.getRequest().getHeader().getFirstValue("Destination");
        if (destination == null) {
            return Outcome.CONTINUE;
        }
        if (!destination.contains("://")) {
            return Outcome.CONTINUE;
        }
        if (!this.isSameSchemeHostAndPort(this.getProtocol(exc) + "://" + exc.getRequest().getHeader().getHost(), destination)) {
            return Outcome.CONTINUE;
        }
        if (exc.getDestinations().isEmpty()) {
            exc.getRequest().getHeader().setValue("Destination", new URL(destination).getFile());
            return Outcome.CONTINUE;
        }
        URL target = new URL(exc.getDestinations().get(0));
        exc.getRequest().getHeader().setValue("Destination", Relocator.getNewLocation(destination, target.getProtocol(), target.getHost(), target.getPort() == -1 ? target.getDefaultPort() : target.getPort(), exc.getHandler().getContextPath(exc)));
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        if (exc.getResponse() == null) {
            return Outcome.CONTINUE;
        }
        String location = exc.getResponse().getHeader().getFirstValue("Location");
        if (location == null) {
            return Outcome.CONTINUE;
        }
        if (!location.contains("://")) {
            return Outcome.CONTINUE;
        }
        if (!this.isSameSchemeHostAndPort(location, exc.getDestinations().get(0))) {
            return Outcome.CONTINUE;
        }
        if (exc.getOriginalHostHeaderHost() == null) {
            exc.getResponse().getHeader().setValue("Location", new URL(location).getFile());
            return Outcome.CONTINUE;
        }
        exc.getResponse().getHeader().setValue("Location", Relocator.getNewLocation(location, this.getProtocol(exc), exc.getOriginalHostHeaderHost(), this.getPort(exc), exc.getHandler().getContextPath(exc)));
        return Outcome.CONTINUE;
    }

    private boolean isSameSchemeHostAndPort(String location2, String location) throws MalformedURLException {
        try {
            int loc1Port;
            if (location.startsWith("/") || location2.startsWith("/")) {
                return false;
            }
            URL loc2 = new URL(location2);
            URL loc1 = new URL(location);
            if (loc2.getProtocol() != null && !loc2.getProtocol().equals(loc1.getProtocol())) {
                return false;
            }
            if (loc2.getHost() != null && !loc2.getHost().equals(loc1.getHost())) {
                return false;
            }
            int loc2Port = loc2.getPort() == -1 ? loc2.getDefaultPort() : loc2.getPort();
            int n = loc1Port = loc1.getPort() == -1 ? loc1.getDefaultPort() : loc1.getPort();
            return loc2Port == loc1Port;
        }
        catch (MalformedURLException e) {
            if (e.getMessage().startsWith("unknown protocol:")) {
                return false;
            }
            log.warn("Location: " + location + " Location2: " + location2, (Throwable)e);
            return false;
        }
    }

    int getPort(Exchange exc) {
        return exc.getHandler().getLocalPort();
    }

    private String getProtocol(Exchange exc) {
        Rule r = exc.getRule();
        return r != null && r instanceof AbstractServiceProxy && ((AbstractServiceProxy)r).getSslInboundContext() != null ? "https" : "http";
    }
}

