/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.IValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class SchematronValidator
implements IValidator {
    private static Logger log = LoggerFactory.getLogger((String)SchematronValidator.class.getName());
    private final ArrayBlockingQueue<Transformer> transformers;
    private final XMLInputFactory xmlInputFactory;
    private final ValidatorInterceptor.FailureHandler failureHandler;
    private final XOPReconstitutor xopr = new XOPReconstitutor();
    private final AtomicLong valid = new AtomicLong();
    private final AtomicLong invalid = new AtomicLong();

    public SchematronValidator(ResolverMap resourceResolver, String schematron, ValidatorInterceptor.FailureHandler failureHandler, Router router, BeanFactory beanFactory) throws Exception {
        TransformerFactory fac;
        this.failureHandler = failureHandler;
        try {
            fac = (TransformerFactory)beanFactory.getBean("transformerFactory", TransformerFactory.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RuntimeException("Please define a bean called 'transformerFactory' in monitor-beans.xml, e.g. with <spring:bean id=\"transformerFactory\" class=\"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl\" />", e);
        }
        fac.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                return new StreamSource(SchematronValidator.class.getResourceAsStream(href));
            }
        });
        Transformer t = fac.newTransformer(new StreamSource(SchematronValidator.class.getResourceAsStream("conformance1-5.xsl")));
        DOMResult r = new DOMResult();
        t.transform(new StreamSource(router.getResolverMap().resolve(schematron)), r);
        fac.setURIResolver(null);
        int concurrency = Runtime.getRuntime().availableProcessors() * 2;
        this.transformers = new ArrayBlockingQueue(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            Transformer transformer = fac.newTransformer(new DOMSource(r.getNode()));
            transformer.setErrorListener(new NullErrorListener());
            this.transformers.put(transformer);
        }
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome validateMessage(Exchange exc, Message msg, String source) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLEventReader parser;
            Transformer transformer = this.transformers.take();
            try {
                transformer.transform(new StreamSource(this.xopr.reconstituteIfNecessary(msg)), new StreamResult(baos));
            }
            finally {
                this.transformers.put(transformer);
            }
            byte[] result = baos.toByteArray();
            XMLInputFactory xMLInputFactory = this.xmlInputFactory;
            synchronized (xMLInputFactory) {
                parser = this.xmlInputFactory.createXMLEventReader(new ByteArrayInputStream(result));
            }
            while (parser.hasNext()) {
                StartElement startElement;
                XMLEvent event = parser.nextEvent();
                if (!event.isStartElement() || !(startElement = (StartElement)event).getName().getLocalPart().equals("failed-assert")) continue;
                this.setErrorMessage(exc, new String(result, Constants.UTF_8_CHARSET), false, source);
                this.invalid.incrementAndGet();
                return Outcome.ABORT;
            }
        }
        catch (TransformerException e) {
            this.setErrorMessage(exc, e.getMessage(), true, source);
            this.invalid.incrementAndGet();
            return Outcome.ABORT;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.setErrorMessage(exc, "internal error", true, source);
            this.invalid.incrementAndGet();
            return Outcome.ABORT;
        }
        this.valid.incrementAndGet();
        return Outcome.CONTINUE;
    }

    private void setErrorMessage(Exchange exc, String message, boolean escape, String source) {
        String MSG_HEADER = "<?xml version=\"1.0\"?>\r\n<error" + (String)(escape ? " source=\"" + StringEscapeUtils.escapeXml((String)source) + "\"" : "") + ">";
        String MSG_FOOTER = "</error>";
        if (escape) {
            message = MSG_HEADER + StringEscapeUtils.escapeXml((String)message) + MSG_FOOTER;
        }
        if (this.failureHandler != null) {
            this.failureHandler.handleFailure((String)message, exc);
            exc.setResponse(Response.badRequest().contentType("text/xml;charset=UTF-8").body((MSG_HEADER + MSG_FOOTER).getBytes(Constants.UTF_8_CHARSET)).build());
        } else {
            exc.setResponse(Response.badRequest().contentType("text/xml;charset=UTF-8").body(((String)message).getBytes(Constants.UTF_8_CHARSET)).build());
        }
        if (!escape) {
            exc.getResponse().getHeader().add("X-Validation-Error-Source", source);
        }
    }

    @Override
    public long getValid() {
        return this.valid.get();
    }

    @Override
    public long getInvalid() {
        return this.invalid.get();
    }

    private static final class NullErrorListener
    implements ErrorListener {
        private NullErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
        }
    }
}

