/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.IValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.JSONValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.SchematronValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.WSDLValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.XMLSchemaValidator;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.SOAPProxy;
import com.predic8.membrane.core.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@MCElement(name="validator")
public class ValidatorInterceptor
extends AbstractInterceptor
implements ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger((String)ValidatorInterceptor.class.getName());
    private String wsdl;
    private String schema;
    private String jsonSchema;
    private String schematron;
    private String failureHandler;
    private boolean skipFaults;
    private IValidator validator;
    private ResolverMap resourceResolver;
    private ApplicationContext applicationContext;

    private void setValidator(IValidator validator) throws Exception {
        if (this.validator != null) {
            throw new Exception("<validator> cannot have more than one validator attribute.");
        }
        this.validator = validator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void init() throws Exception {
        String baseLocation;
        this.validator = null;
        String string = baseLocation = this.router == null ? null : this.router.getBaseLocation();
        if (this.wsdl != null) {
            this.name = "SOAP Validator";
            this.setValidator(new WSDLValidator(this.resourceResolver, ResolverMap.combine(baseLocation, this.wsdl), this.createFailureHandler(), this.skipFaults));
        }
        if (this.schema != null) {
            this.name = "XML Schema Validator";
            this.setValidator(new XMLSchemaValidator(this.resourceResolver, ResolverMap.combine(baseLocation, this.schema), this.createFailureHandler()));
        }
        if (this.jsonSchema != null) {
            this.name = "JSON Schema Validator";
            this.setValidator(new JSONValidator(this.resourceResolver, ResolverMap.combine(baseLocation, this.jsonSchema), this.createFailureHandler()));
        }
        if (this.schematron != null) {
            this.name = "Schematron Validator";
            this.setValidator(new SchematronValidator(this.resourceResolver, ResolverMap.combine(baseLocation, this.schematron), this.createFailureHandler(), this.router, (BeanFactory)this.applicationContext));
        }
        if (this.validator == null) {
            Rule parent = this.router.getParentProxy(this);
            if (parent instanceof SOAPProxy) {
                this.wsdl = ((SOAPProxy)parent).getWsdl();
                this.name = "SOAP Validator";
                this.setValidator(new WSDLValidator(this.resourceResolver, ResolverMap.combine(baseLocation, this.wsdl), this.createFailureHandler(), this.skipFaults));
            }
            if (this.validator == null) {
                throw new Exception("<validator> must have an attribute specifying the validator.");
            }
        }
        if (this.skipFaults && this.wsdl == null) {
            throw new Exception("validator/@skipFaults only makes sense with validator/@wsdl");
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRequest().isBodyEmpty()) {
            return Outcome.CONTINUE;
        }
        return this.validator.validateMessage(exc, exc.getRequest(), "request");
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        if (exc.getResponse().isBodyEmpty()) {
            return Outcome.CONTINUE;
        }
        return this.validator.validateMessage(exc, exc.getResponse(), "response");
    }

    @MCAttribute
    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public String getSchema() {
        return this.schema;
    }

    @MCAttribute
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getFailureHandler() {
        return this.failureHandler;
    }

    @MCAttribute
    public void setFailureHandler(String failureHandler) {
        this.failureHandler = failureHandler;
    }

    public String getJsonSchema() {
        return this.jsonSchema;
    }

    @MCAttribute
    public void setJsonSchema(String jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public String getSchematron() {
        return this.schematron;
    }

    @MCAttribute
    public void setSchematron(String schematron) {
        this.schematron = schematron;
    }

    public boolean isSkipFaults() {
        return this.skipFaults;
    }

    @MCAttribute
    public void setSkipFaults(boolean skipFaults) {
        this.skipFaults = skipFaults;
    }

    @Override
    public void init(Router router) throws Exception {
        this.resourceResolver = router.getResolverMap();
        super.init(router);
    }

    public void setResourceResolver(ResolverMap resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Override
    public String getShortDescription() {
        return this.validator.getInvalid() + " of " + (this.validator.getValid() + this.validator.getInvalid()) + " messages have been invalid.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder(this.getShortDescription());
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" according to ");
        if (this.wsdl != null) {
            sb.append("the WSDL at <br/>");
            sb.append(TextUtil.linkURL(this.wsdl));
        }
        if (this.schema != null) {
            sb.append("the XML Schema at <br/>");
            sb.append(TextUtil.linkURL(this.schema));
        }
        if (this.jsonSchema != null) {
            sb.append("the JSON Schema at <br/>");
            sb.append(TextUtil.linkURL(this.jsonSchema));
        }
        if (this.schematron != null) {
            sb.append("the Schematron at <br/>");
            sb.append(TextUtil.linkURL(this.schematron));
        }
        sb.append(" .");
        return sb.toString();
    }

    private FailureHandler createFailureHandler() {
        if (this.failureHandler == null || this.failureHandler.equals("response")) {
            return null;
        }
        if (this.failureHandler.equals("log")) {
            return new FailureHandler(){

                @Override
                public void handleFailure(String message, Exchange exc) {
                    log.info("Validation failure: " + message);
                }
            };
        }
        throw new IllegalArgumentException("Unknown failureHandler type: " + this.failureHandler);
    }

    public static interface FailureHandler {
        public static final FailureHandler VOID = new FailureHandler(){

            @Override
            public void handleFailure(String message, Exchange exc) {
            }
        };

        public void handleFailure(String var1, Exchange var2);
    }
}

