/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.schemavalidation.AbstractXMLSchemaValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.MessageUtil;
import com.predic8.membrane.core.util.SOAPUtil;
import com.predic8.schema.Schema;
import com.predic8.wsdl.Types;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.WSDLParserContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDLValidator
extends AbstractXMLSchemaValidator {
    static Logger log = LoggerFactory.getLogger((String)WSDLValidator.class.getName());
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public WSDLValidator(ResolverMap resourceResolver, String location, ValidatorInterceptor.FailureHandler failureHandler, boolean skipFaults) throws Exception {
        super(resourceResolver, location, failureHandler, skipFaults);
    }

    public WSDLValidator(ResolverMap resourceResolver, String location, ValidatorInterceptor.FailureHandler failureHandler) throws Exception {
        super(resourceResolver, location, failureHandler);
    }

    @Override
    protected List<Schema> getSchemas() {
        WSDLParserContext ctx = new WSDLParserContext();
        ctx.setInput((Object)this.location);
        try {
            WSDLParser wsdlParser = new WSDLParser();
            wsdlParser.setResourceResolver((Object)this.resourceResolver.toExternalResolver().toExternalResolver());
            ArrayList<Schema> schemaList = new ArrayList<Schema>();
            for (Types t : wsdlParser.parse(ctx).getTypes()) {
                schemaList.addAll(t.getSchemas());
            }
            return schemaList;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not download the WSDL " + this.location + " or its dependent XML Schemas.", e);
        }
    }

    @Override
    protected Source getMessageBody(InputStream input) throws Exception {
        return MessageUtil.getSOAPBody(input);
    }

    @Override
    protected Response createErrorResponse(String message) {
        return HttpUtil.createSOAPValidationErrorResponse(message);
    }

    @Override
    protected boolean isFault(Message msg) {
        return SOAPUtil.isFault(xmlInputFactory, this.xopr, msg);
    }

    @Override
    protected String getPreliminaryError(XOPReconstitutor xopr, Message msg) {
        if (SOAPUtil.isSOAP(xmlInputFactory, xopr, msg)) {
            return null;
        }
        return "Not a SOAP message.";
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

