/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.schemavalidation.AbstractXMLSchemaValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.SchemaValidatorErrorHandler;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.schema.Schema;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLSchemaValidator
extends AbstractXMLSchemaValidator {
    private static Logger log = LoggerFactory.getLogger((String)XMLSchemaValidator.class.getName());

    public XMLSchemaValidator(ResolverMap resourceResolver, String location, ValidatorInterceptor.FailureHandler failureHandler) throws Exception {
        super(resourceResolver, location, failureHandler);
    }

    @Override
    protected List<Schema> getSchemas() {
        return null;
    }

    @Override
    protected List<Validator> createValidators() throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setResourceResolver(this.resourceResolver.toLSResourceResolver());
        ArrayList<Validator> validators = new ArrayList<Validator>();
        log.debug("Creating validator for schema: " + this.location);
        StreamSource ss = new StreamSource(this.resourceResolver.resolve(this.location));
        ss.setSystemId(this.location);
        Validator validator = sf.newSchema(ss).newValidator();
        validator.setResourceResolver(this.resourceResolver.toLSResourceResolver());
        validator.setErrorHandler(new SchemaValidatorErrorHandler());
        validators.add(validator);
        return validators;
    }

    @Override
    protected Source getMessageBody(InputStream input) throws Exception {
        return new StreamSource(input);
    }

    @Override
    protected Response createErrorResponse(String message) {
        return Response.badRequest().contentType("text/xml;charset=UTF-8").body(("<error>" + StringEscapeUtils.escapeXml((String)message) + "</error>").getBytes(Constants.UTF_8_CHARSET)).build();
    }

    @Override
    protected boolean isFault(Message msg) {
        return false;
    }

    @Override
    protected String getPreliminaryError(XOPReconstitutor xopr, Message msg) {
        return null;
    }
}

