/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.server;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="webServer")
public class WebServerInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)WebServerInterceptor.class.getName());
    private static String[] EMPTY = new String[0];
    String docBase = "docBase";
    boolean docBaseIsNormalized = false;
    String[] index = EMPTY;
    boolean generateIndex;

    public WebServerInterceptor() {
        this.name = "Web Server";
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.normalizeDocBase();
    }

    private void normalizeDocBase() {
        this.docBase = this.docBase.replaceAll(Pattern.quote("\\"), "/");
        if (!this.docBaseIsNormalized) {
            if (!this.docBase.endsWith(File.separator)) {
                this.docBase = this.docBase + "/";
            }
            try {
                this.docBase = this.getAbsolutePathWithSchemePrefix(this.docBase);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.docBaseIsNormalized = true;
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.normalizeDocBase();
        String uri = this.router.getUriFactory().create(exc.getDestinations().get(0)).getPath();
        log.debug("request: " + uri);
        if (this.escapesPath(uri) || this.escapesPath(this.router.getUriFactory().create(uri).getPath())) {
            exc.setResponse(Response.badRequest().body("").build());
            return Outcome.ABORT;
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        try {
            exc.setTimeReqSent(System.currentTimeMillis());
            exc.setResponse(WebServerInterceptor.createResponse(this.router.getResolverMap(), ResolverMap.combine(this.router.getBaseLocation(), this.docBase, uri)));
            exc.setReceived();
            exc.setTimeResReceived(System.currentTimeMillis());
            return Outcome.RETURN;
        }
        catch (ResourceRetrievalException e) {
            List<String> children;
            for (String i : this.index) {
                try {
                    exc.setResponse(WebServerInterceptor.createResponse(this.router.getResolverMap(), ResolverMap.combine(this.router.getBaseLocation(), this.docBase, uri + i)));
                    exc.setReceived();
                    exc.setTimeResReceived(System.currentTimeMillis());
                    return Outcome.RETURN;
                }
                catch (ResourceRetrievalException resourceRetrievalException) {
                }
            }
            String uri2 = uri + "/";
            for (String i : this.index) {
                try {
                    exc.setResponse(WebServerInterceptor.createResponse(this.router.getResolverMap(), ResolverMap.combine(this.router.getBaseLocation(), this.docBase, uri2 + i)));
                    exc.setReceived();
                    exc.setTimeResReceived(System.currentTimeMillis());
                    return Outcome.RETURN;
                }
                catch (ResourceRetrievalException resourceRetrievalException) {
                }
            }
            if (this.generateIndex && (children = this.router.getResolverMap().getChildren(ResolverMap.combine(this.router.getBaseLocation(), this.docBase, uri))) != null) {
                Collections.sort(children);
                StringBuilder sb = new StringBuilder();
                sb.append("<html><body><tt>");
                Object base = uri;
                if (((String)base).endsWith("/")) {
                    base = "";
                } else {
                    base = exc.getRequestURI();
                    int p = ((String)base).lastIndexOf(47);
                    if (p != -1) {
                        base = ((String)base).substring(p + 1);
                    }
                    if (((String)base).length() == 0) {
                        base = ".";
                    }
                    base = (String)base + "/";
                }
                for (String child : children) {
                    sb.append("<a href=\"" + (String)base + child + "\">" + child + "</a><br/>");
                }
                sb.append("</tt></body></html>");
                exc.setResponse(Response.ok().contentType("text/html").body(sb.toString()).build());
                return Outcome.RETURN;
            }
            exc.setResponse(Response.notFound().build());
            return Outcome.ABORT;
        }
    }

    private boolean escapesPath(String uri) {
        return uri.endsWith("..") || uri.endsWith("../") || uri.endsWith("..\\") || uri.contains("/../") || uri.contains("..\\") || uri.contains(":/") || uri.contains("file:\\") || uri.startsWith("..");
    }

    public static Response createResponse(ResolverMap rr, String resPath) throws IOException {
        return Response.ok().header(HttpUtil.createHeaders(WebServerInterceptor.getContentType(resPath), new String[0])).body(rr.resolve(resPath), true).build();
    }

    private static String getContentType(String uri) {
        if (uri.endsWith(".css")) {
            return "text/css";
        }
        if (uri.endsWith(".js")) {
            return "application/javascript";
        }
        if (uri.endsWith(".wsdl")) {
            return "text/xml";
        }
        if (uri.endsWith(".xml")) {
            return "text/xml";
        }
        if (uri.endsWith(".xsd")) {
            return "text/xml";
        }
        if (uri.endsWith(".html")) {
            return "text/html";
        }
        if (uri.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (uri.endsWith(".png")) {
            return "image/png";
        }
        if (uri.endsWith(".json")) {
            return "application/json";
        }
        if (uri.endsWith(".svg")) {
            return "image/svg+xml";
        }
        return null;
    }

    public String getDocBase() {
        return this.docBase;
    }

    @MCAttribute
    @Required
    public void setDocBase(String docBase) {
        this.docBase = docBase;
        this.docBaseIsNormalized = false;
    }

    private String getAbsolutePathWithSchemePrefix(String path) {
        try {
            Path p = Paths.get(path, new String[0]);
            if (p.isAbsolute()) {
                return p.toUri().toString();
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        this.router.getResolverMap();
        String newPath = ResolverMap.combine(this.router.getBaseLocation(), path);
        if (newPath.endsWith(File.separator + File.separator)) {
            newPath = newPath.substring(0, newPath.length() - 1);
        }
        if (!newPath.endsWith("/")) {
            return newPath + "/";
        }
        return newPath;
    }

    public String getIndex() {
        return StringUtils.join((Object[])this.index, (String)",");
    }

    @MCAttribute
    public void setIndex(String i) {
        this.index = i == null ? EMPTY : i.split(",");
    }

    public boolean isGenerateIndex() {
        return this.generateIndex;
    }

    @MCAttribute
    public void setGenerateIndex(boolean generateIndex) {
        this.generateIndex = generateIndex;
    }

    @Override
    public String getShortDescription() {
        return "Serves static files from<br/>" + TextUtil.linkURL(this.docBase) + " .";
    }
}

