/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.interceptor.session.SessionManager;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

@MCElement(name="inMemorySessionManager2")
public class InMemorySessionManager
extends SessionManager {
    static final String ID_NAME = "_in_memory_session_id";
    Cache<String, Session> sessions;
    protected String cookieNamePrefix = UUID.randomUUID().toString().substring(0, 8);

    @Override
    public void init(Router router) throws Exception {
        this.sessions = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(this.getExpiresAfterSeconds())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> cookieValueToAttributes(String cookie) {
        try {
            Cache<String, Session> cache = this.sessions;
            synchronized (cache) {
                return ((Session)this.sessions.get((Object)cookie.split("=true")[0], () -> new Session(this.usernameKeyName, new HashMap<String, Object>()))).get();
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<Session, String> getCookieValues(Session ... session) {
        this.createSessionIdsForNewSessions(session);
        this.fixMergedSessionId(session);
        Cache<String, Session> cache = this.sessions;
        synchronized (cache) {
            this.addSessionToCache(session);
        }
        return this.mapSessionToName(session);
    }

    private Map<Session, String> mapSessionToName(Session[] session) {
        return Arrays.stream(session).collect(Collectors.toMap(s -> s, s -> (String)s.get(ID_NAME)));
    }

    private void addSessionToCache(Session[] session) {
        Arrays.stream(session).forEach(s -> this.sessions.put((Object)((String)s.get(ID_NAME)), s));
    }

    private void createSessionIdsForNewSessions(Session[] session) {
        Arrays.stream(session).filter(s -> s.get(ID_NAME) == null).forEach(s -> s.put(ID_NAME, this.cookieNamePrefix + "-" + UUID.randomUUID().toString()));
    }

    private void fixMergedSessionId(Session[] session) {
        Arrays.stream(session).filter(s -> s.get(ID_NAME).toString().contains(",")).forEach(s -> s.put(ID_NAME, this.cookieNamePrefix + "-" + UUID.randomUUID().toString()));
    }

    @Override
    public List<String> getInvalidCookies(Exchange exc, String validCookie) {
        List<HeaderField> values = exc.getRequest().getHeader().getValues(new HeaderName("Cookie"));
        return values.stream().filter(hf -> hf.getValue().startsWith(this.cookieNamePrefix)).filter(hf -> !hf.getValue().contains(validCookie)).map(hf -> hf.getValue()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isValidCookieForThisSessionManager(String cookie) {
        Cache<String, Session> cache = this.sessions;
        synchronized (cache) {
            return cookie.startsWith(this.cookieNamePrefix) && this.sessions.getIfPresent((Object)cookie.split("=true")[0]) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cookieRenewalNeeded(String originalCookie) {
        Cache<String, Session> cache = this.sessions;
        synchronized (cache) {
            return this.sessions.getIfPresent((Object)originalCookie) != null;
        }
    }
}

