/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.session;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.interceptor.session.SessionManager;
import com.predic8.membrane.core.util.RedisConnector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;

@MCElement(name="redisSessionManager")
public class RedisSessionManager
extends SessionManager {
    protected String cookieNamePrefix = UUID.randomUUID().toString().substring(0, 8);
    private ObjectMapper objMapper = new ObjectMapper();
    private RedisConnector connector;
    static final String ID_NAME = "_in_memory_session_id";

    @Override
    public void init(Router router) throws Exception {
    }

    @Override
    protected Map<String, Object> cookieValueToAttributes(String cookie) {
        Map<String, Object> map;
        block8: {
            Jedis jedis = this.connector.getJedisWithDb();
            try {
                Map<String, Object> map2 = map = !jedis.get(cookie.split("=true")[0]).equals("nil") ? this.jsonStringtoSession(jedis.getEx(cookie.split("=true")[0], this.connector.getParams())).get() : new Session(this.usernameKeyName, new HashMap<String, Object>()).get();
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    return Collections.emptyMap();
                }
            }
            jedis.close();
        }
        return map;
    }

    @Override
    protected Map<Session, String> getCookieValues(Session ... session) {
        this.createSessionIdsForNewSessions(session);
        this.fixMergedSessionId(session);
        this.addSessionToRedis(session);
        return this.mapSessionToName(session);
    }

    private Map<Session, String> mapSessionToName(Session[] session) {
        return Arrays.stream(session).collect(Collectors.toMap(s -> s, s -> (String)s.get(ID_NAME)));
    }

    private void addSessionToRedis(Session[] session) {
        try (Jedis jedis = this.connector.getJedisWithDb();){
            Arrays.stream(session).forEach(s -> {
                try {
                    jedis.setex((String)s.get(ID_NAME), this.getExpiresAfterSeconds(), this.sessionToJsonString((Session)s));
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private void createSessionIdsForNewSessions(Session[] session) {
        Arrays.stream(session).filter(s -> s.get(ID_NAME) == null).forEach(s -> s.put(ID_NAME, this.cookieNamePrefix + "-" + UUID.randomUUID()));
    }

    private void fixMergedSessionId(Session[] session) {
        Arrays.stream(session).filter(s -> s.get(ID_NAME).toString().contains(",")).forEach(s -> s.put(ID_NAME, this.cookieNamePrefix + "-" + UUID.randomUUID()));
    }

    private String sessionToJsonString(Session session) throws JsonProcessingException {
        return this.objMapper.writeValueAsString((Object)session);
    }

    private Session jsonStringtoSession(String session) throws JsonProcessingException {
        return (Session)this.objMapper.readValue(session, Session.class);
    }

    @Override
    public List<String> getInvalidCookies(Exchange exc, String validCookie) {
        List<HeaderField> values = exc.getRequest().getHeader().getValues(new HeaderName("Cookie"));
        return values.stream().map(HeaderField::getValue).filter(value -> value.startsWith(this.cookieNamePrefix)).filter(value -> !value.contains(validCookie)).collect(Collectors.toList());
    }

    @Override
    protected boolean isValidCookieForThisSessionManager(String cookie) {
        try (Jedis jedis = this.connector.getJedisWithDb();){
            boolean bl = cookie.startsWith(this.cookieNamePrefix) && !jedis.get(cookie.split("=true")[0]).equals("nil");
            return bl;
        }
    }

    @Override
    protected boolean cookieRenewalNeeded(String originalCookie) {
        try (Jedis jedis = this.connector.getJedisWithDb();){
            boolean bl = !jedis.get(originalCookie).equals("nil");
            return bl;
        }
    }

    public RedisConnector getConnector() {
        return this.connector;
    }

    @MCAttribute
    public void setConnector(RedisConnector connector) {
        this.connector = connector;
    }
}

