/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.session;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

public class Session {
    protected static final String INTERNAL_PREFIX = "_internal_";
    protected static final String AUTHORIZATION_LEVEL = "auth_level";
    private String usernameKeyName;
    Map<String, Object> content;
    boolean isDirty;

    public Session(String usernameKeyName, Map<String, Object> content) {
        this.usernameKeyName = usernameKeyName;
        this.content = content;
        if (this.getInternal(AUTHORIZATION_LEVEL) == null) {
            this.setAuthorization(AuthorizationLevel.ANONYMOUS);
        }
        this.isDirty = false;
    }

    public Session() {
    }

    public Session(Map<String, Object> content) {
        this("username", content);
    }

    public <T> T get(String key) {
        return (T)this.getMultiple(key).get(key);
    }

    public <T> void put(String key, T value) {
        this.put(Collections.singletonMap(key, value));
    }

    public Map<String, Object> getMultiple(String ... keys) {
        HashSet<String> keysUnique = new HashSet<String>(Arrays.asList(keys));
        return this.content.entrySet().stream().filter(entry -> keysUnique.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
    }

    public void remove(String ... keys) {
        HashSet<String> keysUnique = new HashSet<String>(Arrays.asList(keys));
        this.content = this.content.entrySet().stream().filter(entry -> !keysUnique.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
        this.dirty();
    }

    public void put(Map<String, Object> map) {
        this.content.putAll(map);
        this.dirty();
    }

    private void dirty() {
        this.isDirty = true;
    }

    public Map<String, Object> get() {
        return this.content;
    }

    public void clear() {
        this.content.clear();
    }

    public void setUsername(String username) {
        this.put(this.usernameKeyName, username);
    }

    @JsonIgnore
    public <T> T getUsername() {
        return this.get(this.usernameKeyName);
    }

    public void authorize(String username) {
        this.setUsername(username);
        this.setAuthorization(AuthorizationLevel.VERIFIED);
    }

    protected void setAuthorization(AuthorizationLevel level) {
        this.putInternal(AUTHORIZATION_LEVEL, level.name());
    }

    protected AuthorizationLevel getAuthorization() {
        try {
            return AuthorizationLevel.valueOf((String)this.getInternal(AUTHORIZATION_LEVEL));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.setAuthorization(AuthorizationLevel.ANONYMOUS);
            return AuthorizationLevel.ANONYMOUS;
        }
    }

    @JsonIgnore
    public boolean isVerified() {
        return this.getAuthorization() == AuthorizationLevel.VERIFIED && this.getUsername() != null;
    }

    public void clearAuthentication() {
        this.removeInternal(this.usernameKeyName);
        this.removeInternal(AUTHORIZATION_LEVEL);
    }

    protected String internalKey(String key) {
        return INTERNAL_PREFIX + key;
    }

    protected <T> void putInternal(String key, T value) {
        this.put(this.internalKey(key), value);
    }

    protected <T> T getInternal(String key) {
        return this.get(this.internalKey(key));
    }

    protected void removeInternal(String key) {
        this.remove(this.internalKey(key));
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public void setContent(Map<String, Object> content) {
        this.content = content;
    }

    public String getUsernameKeyName() {
        return this.usernameKeyName;
    }

    public void setUsernameKeyName(String usernameKeyName) {
        this.usernameKeyName = usernameKeyName;
    }

    public static enum AuthorizationLevel {
        ANONYMOUS,
        VERIFIED;

    }
}

