/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.rules.RuleKey;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionManager {
    public static final String SESSION_VALUE_SEPARATOR = ",";
    public static final String VALUE_TO_EXPIRE_SESSION_IN_BROWSER = "Expires=Thu, 01 Jan 1970 00:00:00 GMT";
    Logger log = LoggerFactory.getLogger(SessionManager.class);
    public static final String SESSION = "SESSION";
    public static final String SESSION_COOKIE_ORIGINAL = "SESSION_COOKIE_ORIGINAL";
    protected String usernameKeyName = "username";
    long expiresAfterSeconds = 900L;
    String domain;
    boolean httpOnly = false;
    String sameSite = null;
    String issuer;
    protected boolean ttlExpiryRefreshOnAccess = true;
    protected boolean secure = false;
    protected boolean sessionCookie = false;
    Cache<String, String> cookieExpireCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(Duration.ofSeconds(10L)).build();

    private void initIssuer(Exchange exc) {
        String xForwardedProto = exc.getRequest().getHeader().getFirstValue("X-Forwarded-Proto");
        boolean isHTTPS = xForwardedProto != null ? "https".equals(xForwardedProto) : exc.getRule().getSslInboundContext() != null;
        this.issuer = (isHTTPS ? "https://" : "http://") + exc.getOriginalHostHeader();
        RuleKey key = exc.getRule().getKey();
        if (!key.isPathRegExp() && key.getPath() != null) {
            this.issuer = this.issuer + key.getPath();
        }
        this.normalizePublicURL();
    }

    private void normalizePublicURL() {
        if (!this.issuer.endsWith("/")) {
            this.issuer = this.issuer + "/";
        }
    }

    public abstract void init(Router var1) throws Exception;

    protected abstract Map<String, Object> cookieValueToAttributes(String var1);

    protected abstract Map<Session, String> getCookieValues(Session ... var1);

    public abstract List<String> getInvalidCookies(Exchange var1, String var2);

    protected abstract boolean isValidCookieForThisSessionManager(String var1);

    protected abstract boolean cookieRenewalNeeded(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcess(Exchange exc) {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this.issuer == null) {
                this.initIssuer(exc);
            }
        }
        this.getSessionFromExchange(exc).ifPresent(session -> {
            try {
                this.createDefaultResponseIfNeeded(exc);
                this.handleSetCookieHeaderForResponse(exc, (Session)session);
            }
            catch (Exception e) {
                throw new RuntimeException("The newly created session could not be persisted in the Set-Cookie header", e);
            }
        });
    }

    private void createDefaultResponseIfNeeded(Exchange exc) {
        if (exc.getResponse() == null) {
            exc.setResponse(Response.ok().build());
        }
    }

    private void handleSetCookieHeaderForResponse(Exchange exc, Session session) throws Exception {
        Optional<Object> originalCookieValueAtBeginning = Optional.ofNullable(exc.getProperty(SESSION_COOKIE_ORIGINAL));
        if (this.ttlExpiryRefreshOnAccess || session.isDirty() || !originalCookieValueAtBeginning.isPresent() || this.cookieRenewalNeeded(originalCookieValueAtBeginning.get().toString())) {
            String currentCookieValueOfSession = this.getCookieValue(session);
            if (!this.ttlExpiryRefreshOnAccess && originalCookieValueAtBeginning.isPresent() && originalCookieValueAtBeginning.get().toString().trim().equals(currentCookieValueOfSession)) {
                return;
            }
            this.setCookieForCurrentSession(exc, currentCookieValueOfSession);
            this.setCookieForExpiredSessions(exc, currentCookieValueOfSession);
            this.dropRedundantCookieHeaders(exc);
            this.cacheSetCookie(exc, currentCookieValueOfSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheSetCookie(Exchange exc, String currentSessionCookieValue) {
        Optional<HeaderField> setCookie = this.getAllRelevantSetCookieHeaders(exc).filter(e -> e.getValue().contains(currentSessionCookieValue)).findFirst();
        if (setCookie.isPresent()) {
            Cache<String, String> cache = this.cookieExpireCache;
            synchronized (cache) {
                this.cookieExpireCache.put((Object)currentSessionCookieValue, (Object)setCookie.get().getValue());
            }
        }
    }

    private void dropRedundantCookieHeaders(Exchange exc) {
        Map<String, List<String>> setCookieHeaders = this.getAllRelevantSetCookieHeaders(exc).map(hf -> hf.getValue()).map(v -> new AbstractMap.SimpleEntry<String, List<String>>(v.split("=true")[0], Arrays.asList(v))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (List)e.getValue(), (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList())));
        this.removeRedundantExpireCookieIfRefreshed(exc, setCookieHeaders);
    }

    private Stream<HeaderField> getAllRelevantSetCookieHeaders(Exchange exc) {
        return Arrays.stream(exc.getResponse().getHeader().getAllHeaderFields()).filter(hf -> hf.getHeaderName().toString().contains("Set-Cookie")).filter(hf -> hf.getValue().contains("=true")).filter(hf -> this.isValidCookieForThisSessionManager(Arrays.stream(hf.getValue().split(";")).filter(s -> s.contains("=true")).findFirst().get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRefreshIfNoChangeInExpireTime(Exchange exc, Map<String, List<String>> setCookieHeaders) {
        Cache<String, String> cache = this.cookieExpireCache;
        synchronized (cache) {
            setCookieHeaders.entrySet().stream().collect(Collectors.toList()).stream().filter(e -> this.cookieExpireCache.getIfPresent((Object)((String)e.getKey() + "=true")) != null).forEach(e -> ((List)e.getValue()).stream().forEach(cookieEntry -> {
                String cookie = (String)this.cookieExpireCache.getIfPresent((Object)((String)e.getKey() + "=true"));
                if (cookieEntry.equals(cookie)) {
                    ((List)setCookieHeaders.get(e.getKey())).remove(e.getValue());
                    exc.getResponse().getHeader().remove(this.getAllRelevantSetCookieHeaders(exc).filter(hf -> hf.getValue().contains((CharSequence)cookieEntry)).findFirst().get());
                }
            }));
        }
    }

    private void removeRedundantExpireCookieIfRefreshed(Exchange exc, Map<String, List<String>> setCookieHeaders) {
        setCookieHeaders.entrySet().stream().collect(Collectors.toList()).stream().filter(e -> ((List)e.getValue()).size() > 1).filter(e -> ((List)e.getValue()).stream().filter(s -> s.contains(VALUE_TO_EXPIRE_SESSION_IN_BROWSER)).count() == 1L).forEach(e -> {
            ((List)setCookieHeaders.get(e.getKey())).remove(e.getValue());
            exc.getResponse().getHeader().remove(this.getAllRelevantSetCookieHeaders(exc).filter(hf -> hf.getValue().contains(VALUE_TO_EXPIRE_SESSION_IN_BROWSER)).findFirst().get());
        });
    }

    private boolean cookieIsAlreadySet(Exchange exc, String currentSessionCookieValue) {
        return Optional.ofNullable(this.getCookieHeader(exc)).orElseGet(String::new).contains(currentSessionCookieValue);
    }

    private void setCookieForCurrentSession(Exchange exc, String currentSessionCookieValue) {
        if (currentSessionCookieValue.length() > 4093) {
            this.log.warn("Cookie is larger than 4093 bytes, this will not work some browsers.");
        }
        String setCookieValue = currentSessionCookieValue + ";" + String.join((CharSequence)";", this.createCookieAttributes(exc));
        exc.getResponse().getHeader().add("Set-Cookie", setCookieValue);
    }

    private void setCookieForExpiredSessions(Exchange exc, String currentSessionCookieValue) {
        this.cookiesToExpire(exc, currentSessionCookieValue).stream().forEach(cookie -> exc.getResponse().getHeader().add("Set-Cookie", (String)cookie));
    }

    private List<String> cookiesToExpire(Exchange exc, String currentSessionCookieValue) {
        if (this.getCookieHeader(exc) != null) {
            return this.expireCookies(exc, this.getInvalidCookies(exc, this.ttlExpiryRefreshOnAccess ? UUID.randomUUID().toString() : currentSessionCookieValue));
        }
        return new ArrayList<String>();
    }

    private String getCookieValue(Session s) throws Exception {
        return this.getCookieValues(s).values().stream().findFirst().orElseThrow(Exception::new) + "=true";
    }

    private List<String> expireCookies(Exchange exc, List<String> invalidCookies) {
        return invalidCookies.stream().map(cookie -> cookie + ";" + String.join((CharSequence)";", this.createInvalidationAttributes(exc))).collect(Collectors.toList());
    }

    protected Session getSessionInternal(Exchange exc) {
        exc.setProperty(SESSION_COOKIE_ORIGINAL, null);
        if (this.getCookieHeader(exc) == null) {
            return new Session(this.usernameKeyName, new HashMap<String, Object>());
        }
        Map<String, Map<String, Object>> validCookiesAsListOfMaps = this.convertValidCookiesToAttributes(exc);
        Session session = new Session(this.usernameKeyName, this.mergeCookies(validCookiesAsListOfMaps.values().stream().collect(Collectors.toList())));
        if (validCookiesAsListOfMaps.size() == 1) {
            exc.setProperty(SESSION_COOKIE_ORIGINAL, validCookiesAsListOfMaps.keySet().iterator().next());
        }
        return session;
    }

    private Map<String, Object> mergeCookies(List<Map<String, Object>> validCookiesAsListOfMaps) {
        return validCookiesAsListOfMaps.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue(), (e1, e2) -> e1 != null && e1.equals(e2) ? e1 : e1 + SESSION_VALUE_SEPARATOR + e2));
    }

    private Map<String, Map<String, Object>> convertValidCookiesToAttributes(Exchange exc) {
        return this.getCookies(exc).filter(cookie -> this.isValidCookieForThisSessionManager((String)cookie)).collect(Collectors.toMap(cookie -> cookie, cookie -> this.cookieValueToAttributes((String)cookie), (c1, c2) -> c1));
    }

    public Session getSession(Exchange exc) {
        Optional<Session> sessionFromExchange = this.getSessionFromExchange(exc);
        if (sessionFromExchange.isPresent()) {
            return sessionFromExchange.get();
        }
        return this.getSessionFromManager(exc);
    }

    private Session getSessionFromManager(Exchange exc) {
        exc.setProperty(SESSION, this.getSessionInternal(exc));
        return this.getSessionFromExchange(exc).get();
    }

    private Optional<Session> getSessionFromExchange(Exchange exc) {
        return Optional.ofNullable((Session)exc.getProperty(SESSION));
    }

    public List<String> createCookieAttributes(Exchange exc) {
        return Stream.of(this.sessionCookie ? null : "Max-Age=" + this.expiresAfterSeconds, this.sessionCookie ? null : "Expires=" + DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.now(ZoneOffset.UTC).plus(Duration.ofSeconds(this.expiresAfterSeconds))), "Path=/", this.needsSecureAttribute(exc) ? "Secure" : null, this.domain != null ? "Domain=" + this.domain + "; " : null, this.httpOnly ? "HttpOnly" : null, this.sameSite != null ? "SameSite=" + this.sameSite : null).filter(attr -> attr != null).collect(Collectors.toList());
    }

    private boolean needsSecureAttribute(Exchange exc) {
        return exc.getRule().getSslInboundContext() != null || this.secure;
    }

    public List<String> createInvalidationAttributes(Exchange exc) {
        return Stream.of(VALUE_TO_EXPIRE_SESSION_IN_BROWSER, "Path=/", this.needsSecureAttribute(exc) ? "Secure" : null, this.domain != null ? "Domain=" + this.domain + "; " : null, this.httpOnly ? "HttpOnly" : null, this.sameSite != null ? "SameSite=" + this.sameSite : null).filter(attr -> attr != null).collect(Collectors.toList());
    }

    protected Stream<String> getCookies(Exchange exc) {
        return exc.getRequest().getHeader().getValues(new HeaderName("Cookie")).stream().map(s -> s.getValue().split(";")).flatMap(Arrays::stream).map(c -> c.trim());
    }

    public long getExpiresAfterSeconds() {
        return this.expiresAfterSeconds;
    }

    @MCAttribute
    public void setExpiresAfterSeconds(long expiresAfterSeconds) {
        this.expiresAfterSeconds = expiresAfterSeconds;
    }

    public String getDomain() {
        return this.domain;
    }

    @MCAttribute
    public void setDomain(String domain) {
        this.domain = domain;
    }

    protected String getCookieHeader(Exchange exc) {
        return this.getCookies(exc).collect(Collectors.joining(";"));
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @MCAttribute
    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    @MCAttribute
    public void setSameSite(String sameSite) {
        this.sameSite = sameSite;
    }

    protected String[] getAllCookieKeys(Exchange exc) {
        return this.getCookieHeader(exc).split(Pattern.quote(";"));
    }

    public String getIssuer() {
        return this.issuer;
    }

    @MCAttribute
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public boolean isTtlExpiryRefreshOnAccess() {
        return this.ttlExpiryRefreshOnAccess;
    }

    @MCAttribute
    public void setTtlExpiryRefreshOnAccess(boolean ttlExpiryRefreshOnAccess) {
        this.ttlExpiryRefreshOnAccess = ttlExpiryRefreshOnAccess;
    }

    public boolean isSecure() {
        return this.secure;
    }

    @MCAttribute
    public SessionManager setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public boolean isSessionCookie() {
        return this.sessionCookie;
    }

    @MCAttribute
    public SessionManager setSessionCookie(boolean sessionCookie) {
        this.sessionCookie = sessionCookie;
        return this;
    }
}

